/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.List;
import java.util.Optional;

public class CalcUtil {
    static Number sum(Number ... numbers) {
        Number newSum = (Number)CalcUtil.getObject(numbers);
        if (newSum == null) {
            return null;
        }
        if (newSum instanceof Integer) {
            int sum = 0;
            for (Number number : numbers) {
                int nextValue = number.intValue();
                sum += nextValue;
            }
            newSum = sum;
        } else if (newSum instanceof Long) {
            long sum = 0L;
            for (Number number : numbers) {
                long nextValue = number.longValue();
                sum += nextValue;
            }
            newSum = sum;
        } else if (newSum instanceof Float) {
            float sum = 0.0f;
            for (Number number : numbers) {
                float nextValue = number.floatValue();
                sum += nextValue;
            }
            newSum = Float.valueOf(sum);
        } else if (newSum instanceof Double) {
            double sum = 0.0;
            for (Number number : numbers) {
                double nextValue = number.doubleValue();
                sum += nextValue;
            }
            newSum = sum;
        } else {
            return null;
        }
        return newSum;
    }

    static Number divide(Number num1, Number num2) {
        Number[] both = new Number[]{num1, num2};
        Number division = (Number)CalcUtil.getObject(both);
        if (division == null) {
            return null;
        }
        if (division instanceof Integer) {
            return num1.doubleValue() / num2.doubleValue();
        }
        if (division instanceof Long) {
            return num1.longValue() / num2.longValue();
        }
        if (division instanceof Float) {
            return Float.valueOf(num1.floatValue() / num2.floatValue());
        }
        if (division instanceof Double) {
            return num1.doubleValue() / num2.doubleValue();
        }
        return null;
    }

    static Number average(Number ... numbers) {
        Number sum = CalcUtil.sum(numbers);
        return CalcUtil.divide(sum, numbers.length);
    }

    static Class bestClass(Object ... objects) {
        boolean hasInt = false;
        boolean hasFloat = false;
        boolean hasLong = false;
        boolean hasDouble = false;
        boolean hasString = false;
        for (Object object : objects) {
            if (object instanceof Double) {
                hasDouble = true;
                continue;
            }
            if (object instanceof Float) {
                hasFloat = true;
                continue;
            }
            if (object instanceof Long) {
                hasLong = true;
                continue;
            }
            if (object instanceof Integer) {
                hasInt = true;
                continue;
            }
            if (!(object instanceof String)) continue;
            hasString = true;
        }
        if (hasString) {
            return String.class;
        }
        if (hasDouble) {
            return Double.class;
        }
        if (hasFloat) {
            return Float.class;
        }
        if (hasLong) {
            return Long.class;
        }
        if (hasInt) {
            return Integer.class;
        }
        return null;
    }

    static Object convert(Object var, Class type) {
        if (var instanceof Number) {
            Number newNum = (Number)var;
            if (type == Integer.class) {
                return newNum.intValue();
            }
            if (type == Long.class) {
                return newNum.longValue();
            }
            if (type == Float.class) {
                return Float.valueOf(newNum.floatValue());
            }
            if (type == Double.class) {
                return newNum.doubleValue();
            }
            if (type == String.class) {
                return newNum.toString();
            }
        } else {
            if (type == Integer.class) {
                return (int)((Integer)var);
            }
            if (type == Long.class) {
                return (long)((Long)var);
            }
            if (type == Float.class) {
                return Float.valueOf(((Float)var).floatValue());
            }
            if (type == Double.class) {
                return (double)((Double)var);
            }
            if (type == String.class) {
                return var.toString();
            }
        }
        return null;
    }

    static Object convert(Object[] objects, Object var) {
        Object newVar = CalcUtil.getObject(objects);
        if (newVar instanceof Number) {
            Number newNum = (Number)var;
            if (newVar instanceof Integer) {
                return newNum.intValue();
            }
            if (newVar instanceof Long) {
                return newNum.longValue();
            }
            if (newVar instanceof Float) {
                return Float.valueOf(newNum.floatValue());
            }
            if (newVar instanceof Double) {
                return newNum.doubleValue();
            }
            return null;
        }
        if (newVar instanceof String) {
            String string = (String)newVar;
            return string;
        }
        return null;
    }

    static Object getObject(Object ... objects) {
        Class bestClass = CalcUtil.bestClass(objects);
        if (bestClass == String.class) {
            return "";
        }
        if (bestClass == Double.class) {
            return 0.0;
        }
        if (bestClass == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (bestClass == Long.class) {
            return 0L;
        }
        if (bestClass == Integer.class) {
            return 0;
        }
        return null;
    }

    static int compare(Comparable val1, Comparable val2) {
        if (val1.getClass() == val2.getClass()) {
            return val1.compareTo(val2);
        }
        Object[] objects = new Object[]{val1, val2};
        Class bestClass = CalcUtil.bestClass(objects);
        if (bestClass != val1.getClass()) {
            val1 = (Comparable)CalcUtil.convert(val1, bestClass);
        }
        if (bestClass != val2.getClass()) {
            val2 = (Comparable)CalcUtil.convert(val2, bestClass);
        }
        return val1.compareTo(val2);
    }

    public static Optional<List<Class>> reflectInputTypes(int expectedInputCount, List<Class> inputTypes) {
        if (inputTypes == null || inputTypes.size() != expectedInputCount) {
            throw new IllegalArgumentException("Expecting " + expectedInputCount + " types in input, but got " + String.valueOf(inputTypes));
        }
        return Optional.of(inputTypes);
    }
}

