/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.Schema;

public class ProfileImpl
implements Schema {
    private Schema parent;
    private Set<Name> profile;
    private Map<Name, AttributeType> contents = null;

    public ProfileImpl(Schema parent, Set<Name> profile) {
        this.parent = parent;
        this.profile = Collections.unmodifiableSet(profile);
    }

    @Override
    public Set<Name> keySet() {
        return this.profile;
    }

    @Override
    public String getURI() {
        return this.parent.getURI();
    }

    @Override
    public Schema profile(Set<Name> profile) {
        if (!this.profile.containsAll(profile)) {
            TreeSet<Name> set = new TreeSet<Name>(profile);
            set.removeAll(this.profile);
            throw new IllegalArgumentException("Unable to profile the following names: " + String.valueOf(set));
        }
        return this.parent.profile(profile);
    }

    @Override
    public int size() {
        return this.profile.size();
    }

    @Override
    public boolean isEmpty() {
        return this.profile.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.profile.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public AttributeType get(Object key) {
        if (this.profile.contains(key)) {
            return (AttributeType)this.parent.get(key);
        }
        return null;
    }

    @Override
    public AttributeType put(Name key, AttributeType value) {
        throw new UnsupportedOperationException("Profile not mutable");
    }

    @Override
    public AttributeType remove(Object key) {
        throw new UnsupportedOperationException("Profile not mutable");
    }

    @Override
    public void putAll(Map<? extends Name, ? extends AttributeType> t) {
        throw new UnsupportedOperationException("Profile not mutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Profile not mutable");
    }

    @Override
    public void add(AttributeType type) {
        throw new UnsupportedOperationException("Profile not mutable");
    }

    @Override
    public Collection<AttributeType> values() {
        return this.contents().values();
    }

    @Override
    public Set<Map.Entry<Name, AttributeType>> entrySet() {
        return this.contents().entrySet();
    }

    private synchronized Map<Name, AttributeType> contents() {
        if (this.contents == null) {
            this.contents = new LinkedHashMap<Name, AttributeType>();
            for (Name key : this.profile) {
                this.contents.put(key, (AttributeType)this.parent.get(key));
            }
        }
        return this.contents;
    }
}

