/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.Collection;
import java.util.List;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.InternationalString;
import org.geotools.feature.type.ComplexTypeImpl;
import org.geotools.util.Utilities;

public class FeatureTypeImpl
extends ComplexTypeImpl
implements FeatureType {
    private GeometryDescriptor defaultGeometry;
    private CoordinateReferenceSystem crs;

    public FeatureTypeImpl(Name name, Collection<PropertyDescriptor> schema, GeometryDescriptor defaultGeometry, boolean isAbstract, List<Filter> restrictions, AttributeType superType, InternationalString description) {
        super(name, schema, true, isAbstract, restrictions, superType, description);
        this.defaultGeometry = defaultGeometry;
        if (defaultGeometry != null && defaultGeometry.getType() == null) {
            throw new IllegalArgumentException("defaultGeometry must have a GeometryType");
        }
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.crs == null) {
            if (this.getGeometryDescriptor() != null && this.getGeometryDescriptor().getType().getCoordinateReferenceSystem() != null) {
                this.crs = this.defaultGeometry.getType().getCoordinateReferenceSystem();
            }
            if (this.crs == null) {
                for (PropertyDescriptor property : this.getDescriptors()) {
                    GeometryDescriptor geometry;
                    if (!(property instanceof GeometryDescriptor) || (geometry = (GeometryDescriptor)property).getType().getCoordinateReferenceSystem() == null) continue;
                    this.crs = geometry.getType().getCoordinateReferenceSystem();
                    break;
                }
            }
        }
        return this.crs;
    }

    @Override
    public GeometryDescriptor getGeometryDescriptor() {
        if (this.defaultGeometry == null) {
            for (PropertyDescriptor property : this.getDescriptors()) {
                GeometryDescriptor descriptor;
                if (!(property instanceof GeometryDescriptor)) continue;
                this.defaultGeometry = descriptor = (GeometryDescriptor)property;
                break;
            }
        }
        return this.defaultGeometry;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        FeatureType other = (FeatureType)o;
        return Utilities.equals(this.getGeometryDescriptor(), other.getGeometryDescriptor());
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        if (this.defaultGeometry != null) {
            hashCode ^= this.defaultGeometry.hashCode();
        }
        return hashCode;
    }
}

