/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.geotools.api.feature.type.Name;
import org.geotools.util.Utilities;

public class NameImpl
implements Name,
Serializable,
Comparable<NameImpl> {
    private static final long serialVersionUID = 4564070184645559899L;
    protected String namespace;
    protected String local;
    private String separator;

    public NameImpl(String local) {
        this(null, local);
    }

    public NameImpl(String namespace, String local) {
        this(namespace, ":", local);
    }

    public NameImpl(String namespace, String separator, String local) {
        this.namespace = namespace;
        this.separator = separator;
        this.local = local;
    }

    public NameImpl(QName qName) {
        this(qName.getNamespaceURI(), qName.getLocalPart());
    }

    @Override
    public boolean isGlobal() {
        return this.getNamespaceURI() == null;
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespace;
    }

    @Override
    public String getLocalPart() {
        return this.local;
    }

    @Override
    public String getURI() {
        if (this.namespace == null && this.local == null) {
            return null;
        }
        if (this.namespace == null) {
            return this.local;
        }
        if (this.local == null) {
            return this.namespace;
        }
        return new StringBuffer(this.namespace).append(this.separator).append(this.local).toString();
    }

    @Override
    public int hashCode() {
        return (this.namespace == null ? 0 : this.namespace.hashCode()) + 37 * (this.local == null ? 0 : this.local.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Name) {
            Name other = (Name)obj;
            if (!Utilities.equals(this.namespace, other.getNamespaceURI())) {
                return false;
            }
            return Utilities.equals(this.local, other.getLocalPart());
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getURI();
    }

    @Override
    public int compareTo(NameImpl other) {
        if (other == null) {
            return 1;
        }
        int c = this.compare(this.getNamespaceURI(), other.getNamespaceURI());
        return c != 0 ? c : this.compare(this.getLocalPart(), other.getLocalPart());
    }

    private int compare(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2 ? 0 : (s1 == null ? 1 : -1);
        }
        return s1.compareTo(s2);
    }
}

