/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class NumericConverterFactory
implements ConverterFactory {
    private static final Logger LOGGER = Logging.getLogger(NumericConverterFactory.class);
    static HashMap<Class, Class> primitiveToWrapper = new HashMap();

    public Converter createConverter(Class source, Class target, Hints hints) {
        source = NumericConverterFactory.primitiveToWrapperClass(source);
        target = NumericConverterFactory.primitiveToWrapperClass(target);
        if (!Number.class.isAssignableFrom(source) && !String.class.isAssignableFrom(source)) {
            return null;
        }
        if (Long.class.equals((Object)target) || Integer.class.equals((Object)target) || Short.class.equals((Object)target) || Byte.class.equals((Object)target) || BigInteger.class.equals((Object)target) || BigDecimal.class.equals((Object)target) || Double.class.equals((Object)target) || Float.class.equals((Object)target) || Number.class.equals((Object)target)) {
            Boolean boolean1;
            Object safeConversion;
            if (hints != null && (safeConversion = hints.get(ConverterFactory.SAFE_CONVERSION)) instanceof Boolean && (boolean1 = (Boolean)safeConversion).booleanValue()) {
                return new SafeNumericConverter();
            }
            return new NumericConverter();
        }
        return null;
    }

    static String toIntegral(String s) {
        int radex = -1;
        for (int i = s.length() - 1; i > 0; --i) {
            char ch = s.charAt(i);
            if (Character.isDigit(ch) || '-' == ch) continue;
            radex = i;
            break;
        }
        if (radex != -1) {
            return s.substring(0, radex);
        }
        return s;
    }

    static Object cleanSource(Object source, Class target) {
        BigDecimal bigDecimal = NumericConverterFactory.getBigDecimalFromScientificNotation(source, target);
        return bigDecimal != null ? bigDecimal : source;
    }

    static BigDecimal getBigDecimalFromScientificNotation(Object source, Class target) {
        block4: {
            if (source instanceof String) {
                String string = (String)source;
                if (Long.class.equals((Object)target) || Integer.class.equals((Object)target) || Short.class.equals((Object)target) || Byte.class.equals((Object)target) || BigInteger.class.equals((Object)target)) {
                    try {
                        return string.toUpperCase().contains("E") ? new BigDecimal(string) : null;
                    }
                    catch (NumberFormatException ex) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block4;
                        LOGGER.finest("NumberFormatException for source=" + String.valueOf(source));
                    }
                }
            }
        }
        return null;
    }

    static Class primitiveToWrapperClass(Class primitive) {
        if (primitive.isPrimitive()) {
            Class wrapper = primitiveToWrapper.get(primitive);
            primitive = wrapper != null ? wrapper : primitive;
        }
        return primitive;
    }

    static {
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
    }

    static class SafeNumericConverter
    implements Converter {
        SafeNumericConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            return (T)this.convertInternal(source, target);
        }

        public Object convertInternal(Object source, Class<?> target) {
            target = NumericConverterFactory.primitiveToWrapperClass(target);
            if (source instanceof Number) {
                Number number = (Number)source;
                Class<?> c = number.getClass();
                if (BigDecimal.class.equals((Object)target)) {
                    return new BigDecimal(source.toString());
                }
                if (Double.class.equals((Object)target)) {
                    if (c != BigDecimal.class && c != BigInteger.class) {
                        if (c == Float.class) {
                            return Double.valueOf(number.toString());
                        }
                        return number.doubleValue();
                    }
                } else if (Float.class.equals((Object)target)) {
                    if (c == Float.class || c == Integer.class || c == Short.class || c == Byte.class) {
                        return Float.valueOf(number.floatValue());
                    }
                } else if (BigInteger.class.equals((Object)target)) {
                    if (BigInteger.class.isAssignableFrom(c) || c == Long.class || c == Integer.class || c == Short.class || c == Byte.class) {
                        return new BigInteger(number.toString());
                    }
                } else if (Long.class.equals((Object)target)) {
                    if (c == Long.class || c == Integer.class || c == Short.class || c == Byte.class) {
                        return number.longValue();
                    }
                } else if (Integer.class.equals((Object)target)) {
                    if (c == Integer.class || c == Short.class || c == Byte.class) {
                        return number.intValue();
                    }
                } else if (Short.class.equals((Object)target)) {
                    if (c == Short.class || c == Byte.class) {
                        return number.shortValue();
                    }
                } else if (Byte.class.equals((Object)target) && c == Byte.class) {
                    return number.byteValue();
                }
            } else if (source instanceof String) {
                String src = (String)source;
                try {
                    Byte x;
                    if (BigDecimal.class.isAssignableFrom(target)) {
                        return new BigDecimal(src);
                    }
                    if (target == Double.class) {
                        Double x2 = Double.valueOf(src);
                        if (x2.toString().equals(src)) {
                            return x2;
                        }
                    } else if (target == Float.class) {
                        Float x3 = Float.valueOf(src);
                        if (x3.toString().equals(src)) {
                            return x3;
                        }
                    } else if (BigInteger.class.isAssignableFrom(target)) {
                        BigInteger x4 = new BigInteger(src);
                        if (x4.toString().equals(src)) {
                            return x4;
                        }
                    } else if (target == Long.class) {
                        Long x5 = Long.valueOf(src);
                        if (x5.toString().equals(src)) {
                            return x5;
                        }
                    } else if (target == Integer.class) {
                        Integer x6 = Integer.valueOf(src);
                        if (x6.toString().equals(src)) {
                            return x6;
                        }
                    } else if (target == Short.class) {
                        Short x7 = Short.valueOf(src);
                        if (x7.toString().equals(src)) {
                            return x7;
                        }
                    } else if (target == Byte.class && (x = Byte.valueOf(src)).toString().equals(src)) {
                        return x;
                    }
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return null;
        }
    }

    static class NumericConverter
    implements Converter {
        NumericConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            return (T)this.convertInternal(source, target);
        }

        public Object convertInternal(Object source, Class<?> target) {
            if ((source = NumericConverterFactory.cleanSource(source, target = NumericConverterFactory.primitiveToWrapperClass(target))) instanceof Number) {
                Number s = (Number)source;
                if (Long.class.equals((Object)target)) {
                    return s.longValue();
                }
                if (Integer.class.equals((Object)target)) {
                    return s.intValue();
                }
                if (Short.class.equals((Object)target)) {
                    return s.shortValue();
                }
                if (Byte.class.equals((Object)target)) {
                    return s.byteValue();
                }
                if (BigInteger.class.equals((Object)target)) {
                    return BigInteger.valueOf(s.longValue());
                }
                if (Double.class.equals((Object)target)) {
                    return Double.valueOf(s.toString());
                }
                if (Float.class.equals((Object)target)) {
                    return Float.valueOf(s.toString());
                }
                if (BigDecimal.class.equals((Object)target)) {
                    return new BigDecimal(s.toString());
                }
                if (Number.class.equals((Object)target)) {
                    try {
                        return Integer.valueOf(s.toString());
                    }
                    catch (Exception exception) {
                        try {
                            return new BigInteger(s.toString());
                        }
                        catch (Exception exception2) {
                            try {
                                return Double.valueOf(s.toString());
                            }
                            catch (Exception exception3) {
                                try {
                                    return new BigDecimal(s.toString());
                                }
                                catch (Exception exception4) {}
                            }
                        }
                    }
                }
            } else if (source instanceof String) {
                String s = (String)source;
                s = s.trim();
                String integral = NumericConverterFactory.toIntegral(s);
                if (Double.class.equals((Object)target)) {
                    return Double.valueOf(s);
                }
                if (Float.class.equals((Object)target)) {
                    return Float.valueOf(s);
                }
                if (BigDecimal.class.equals((Object)target)) {
                    return new BigDecimal(s);
                }
                if (Long.class.equals((Object)target)) {
                    return Long.valueOf(integral);
                }
                if (Integer.class.equals((Object)target)) {
                    return Integer.valueOf(integral);
                }
                if (Short.class.equals((Object)target)) {
                    return Short.valueOf(integral);
                }
                if (Byte.class.equals((Object)target)) {
                    return Byte.valueOf(integral);
                }
                if (BigInteger.class.equals((Object)target)) {
                    return new BigInteger(integral);
                }
                if (Number.class.equals((Object)target)) {
                    if (integral.equals(s)) {
                        try {
                            return Integer.valueOf(integral);
                        }
                        catch (Exception exception) {
                            try {
                                return new BigInteger(integral);
                            }
                            catch (Exception exception5) {
                                // empty catch block
                            }
                        }
                    }
                    try {
                        return Double.valueOf(s);
                    }
                    catch (Exception exception) {
                        try {
                            return new BigDecimal(s);
                        }
                        catch (Exception exception6) {
                            // empty catch block
                        }
                    }
                }
            }
            return null;
        }
    }
}

