/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.MultiCurve;
import org.geotools.geometry.jts.MultiCurvedGeometry;
import org.geotools.geometry.jts.MultiSurface;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometryTypeConverterFactory
implements ConverterFactory {
    private static final Logger LOGGER = Logging.getLogger(GeometryTypeConverterFactory.class);
    static GeometryFactory gFac = new GeometryFactory();

    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (Geometry.class.isAssignableFrom(source) && CurvedGeometry.class.isAssignableFrom(target)) {
            return new CurvedGeometryConverter();
        }
        if (Geometry.class.isAssignableFrom(source) && Geometry.class.isAssignableFrom(target)) {
            return new GeometryToGeometryConverter();
        }
        return null;
    }

    protected void copyUserProperties(Geometry sourceGeometry, Geometry destGeometry) {
        if (destGeometry != null) {
            HashMap<Class<CoordinateReferenceSystem>, Object> newUserData = new HashMap<Class<CoordinateReferenceSystem>, Object>();
            if (destGeometry.getUserData() instanceof Map) {
                newUserData.putAll((Map)destGeometry.getUserData());
            } else if (destGeometry.getUserData() instanceof CoordinateReferenceSystem) {
                newUserData.put(CoordinateReferenceSystem.class, destGeometry.getUserData());
            }
            if (sourceGeometry.getUserData() instanceof Map) {
                newUserData.putAll((Map)sourceGeometry.getUserData());
            } else if (sourceGeometry.getUserData() instanceof CoordinateReferenceSystem) {
                newUserData.put(CoordinateReferenceSystem.class, sourceGeometry.getUserData());
            }
            destGeometry.setUserData(newUserData);
        }
    }

    private class CurvedGeometryConverter
    implements Converter {
        private CurvedGeometryConverter() {
        }

        private <C extends GeometryCollection, G extends Geometry> List<G> getGeoms(C original) {
            ArrayList<Geometry> components = new ArrayList<Geometry>();
            for (int i = 0; i < original.getNumGeometries(); ++i) {
                components.add(original.getGeometryN(i));
            }
            return components;
        }

        private <G extends Geometry> Double getTolerance(List<G> components) {
            double tolerance = Double.MAX_VALUE;
            for (Geometry currentGeom : components) {
                if (!(currentGeom instanceof CurvedGeometry)) continue;
                CurvedGeometry geometry = (CurvedGeometry)((Object)currentGeom);
                tolerance = Math.min(tolerance, geometry.getTolerance());
            }
            return tolerance;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            block11: {
                block12: {
                    block10: {
                        result /* !! */  = null;
                        sourceGeometry = (Geometry)source;
                        if (!MultiCurvedGeometry.class.isAssignableFrom(target)) break block10;
                        factory = ((Geometry)source).getFactory();
                        if (MultiSurface.class.isAssignableFrom(target)) {
                            components = null;
                            if (source instanceof Polygon) {
                                polygon = (Polygon)source;
                                components = Arrays.asList(new Polygon[]{polygon});
                            } else {
                                components = this.getGeoms((MultiPolygon)source);
                            }
                            tolerance = this.getTolerance(components);
                            result /* !! */  = new MultiSurface(components, factory, tolerance);
                        } else {
                            multiLineString = Converters.convert(source, MultiLineString.class);
                            if (multiLineString == null) {
                                return null;
                            }
                            components = this.getGeoms(multiLineString);
                            tolerance = this.getTolerance(components);
                            result /* !! */  = new MultiCurve(components, factory, tolerance);
                        }
                        break block11;
                    }
                    if (!(source instanceof CircularRing)) break block12;
                    cr = (CircularRing)source;
                    if (!CircularString.class.isAssignableFrom(target)) break block12;
                    result /* !! */  = new CircularString(cr.getControlPoints(), cr.getFactory(), cr.getTolerance());
                    break block11;
                }
                if (!(source instanceof CompoundRing)) ** GOTO lbl-1000
                cr = (CompoundRing)source;
                if (CompoundCurve.class.isAssignableFrom(target)) {
                    result /* !! */  = new CompoundCurve(cr.getComponents(), cr.getFactory(), cr.getTolerance());
                } else if ((converted = Converters.convert(source, LineString.class)).isEmpty()) {
                    components = new ArrayList<LineString>();
                    result /* !! */  = new CompoundRing(components, converted.getFactory(), 1.7976931348623157E308);
                } else {
                    result /* !! */  = converted instanceof LinearRing != false ? new CompoundRing(Arrays.asList(new LineString[]{converted}), ((LineString)source).getFactory(), 1.7976931348623157E308) : new CompoundCurve(Arrays.asList(new LineString[]{converted}), converted.getFactory(), 1.7976931348623157E308);
                }
            }
            if (result /* !! */  != null) {
                GeometryTypeConverterFactory.this.copyUserProperties(sourceGeometry, result /* !! */ );
            }
            converted /* !! */  = result /* !! */ ;
            return (T)converted /* !! */ ;
        }
    }

    private class GeometryToGeometryConverter
    implements Converter {
        private GeometryToGeometryConverter() {
        }

        public <T> List<T> convertAll(GeometryCollection gc, Class<T> target) throws Exception {
            ArrayList<T> result = new ArrayList<T>();
            for (int count = 0; count < gc.getNumGeometries(); ++count) {
                T geo = this.convert(gc.getGeometryN(count), target);
                if (geo == null) continue;
                result.add(geo);
            }
            return result;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            block30: {
                block32: {
                    block40: {
                        block38: {
                            block39: {
                                block36: {
                                    block37: {
                                        block35: {
                                            block34: {
                                                block33: {
                                                    block31: {
                                                        if (target.isAssignableFrom(source.getClass())) {
                                                            return (T)source;
                                                        }
                                                        if (!(source instanceof Geometry)) break block30;
                                                        sourceGeometry = (Geometry)source;
                                                        destGeometry /* !! */  = null;
                                                        if (!MultiPoint.class.isAssignableFrom(target)) break block31;
                                                        if (sourceGeometry.isEmpty()) {
                                                            points = new Point[]{};
                                                        } else if (source instanceof Point) {
                                                            point = (Point)source;
                                                            points = new Point[]{point};
                                                        } else if (source instanceof GeometryCollection) {
                                                            collection = (GeometryCollection)source;
                                                            points = this.convertAll(collection, Point.class).toArray(new Point[0]);
                                                        } else {
                                                            points = new Point[]{this.convert(source, Point.class)};
                                                        }
                                                        destGeometry /* !! */  = GeometryTypeConverterFactory.gFac.createMultiPoint(points);
                                                        break block32;
                                                    }
                                                    if (!MultiLineString.class.isAssignableFrom(target)) break block33;
                                                    if (sourceGeometry.isEmpty()) {
                                                        lineStrings = new LineString[]{};
                                                    } else if (source instanceof LineString) {
                                                        string = (LineString)source;
                                                        lineStrings = new LineString[]{string};
                                                    } else if (source instanceof GeometryCollection) {
                                                        collection = (GeometryCollection)source;
                                                        lineStrings = this.convertAll(collection, LineString.class).toArray(new LineString[0]);
                                                    } else {
                                                        lineStrings = new LineString[]{this.convert(source, LineString.class)};
                                                    }
                                                    destGeometry /* !! */  = GeometryTypeConverterFactory.gFac.createMultiLineString(lineStrings);
                                                    break block32;
                                                }
                                                if (!MultiPolygon.class.isAssignableFrom(target)) break block34;
                                                if (sourceGeometry.isEmpty()) {
                                                    polygons = new Polygon[]{};
                                                } else if (source instanceof Polygon) {
                                                    polygon = (Polygon)source;
                                                    exterior = polygon.getExteriorRing();
                                                    interiors = new LinearRing[polygon.getNumInteriorRing()];
                                                    for (i = 0; i < interiors.length; ++i) {
                                                        interiors[i] = polygon.getInteriorRingN(i);
                                                    }
                                                    polygons = new Polygon[]{GeometryTypeConverterFactory.gFac.createPolygon(exterior, interiors)};
                                                } else if (source instanceof GeometryCollection) {
                                                    collection = (GeometryCollection)source;
                                                    polygons = this.convertAll(collection, Polygon.class).toArray(new Polygon[0]);
                                                } else {
                                                    polygons = new Polygon[]{this.convert(source, Polygon.class)};
                                                }
                                                destGeometry /* !! */  = GeometryTypeConverterFactory.gFac.createMultiPolygon(polygons);
                                                break block32;
                                            }
                                            if (!GeometryCollection.class.isAssignableFrom(target)) break block35;
                                            destGeometry /* !! */  = sourceGeometry.isEmpty() ? GeometryTypeConverterFactory.gFac.createGeometryCollection(new Geometry[0]) : GeometryTypeConverterFactory.gFac.createGeometryCollection(new Geometry[]{sourceGeometry});
                                            break block32;
                                        }
                                        if (!Point.class.isAssignableFrom(target)) break block36;
                                        if (!sourceGeometry.isEmpty()) break block37;
                                        destGeometry /* !! */  = GeometryTypeConverterFactory.gFac.createPoint((Coordinate)null);
                                        break block32;
                                    }
                                    if (!(source instanceof MultiPoint)) ** GOTO lbl-1000
                                    point = (MultiPoint)source;
                                    if (sourceGeometry.getNumGeometries() == 1) {
                                        destGeometry /* !! */  = point.getGeometryN(0).copy();
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        if (GeometryTypeConverterFactory.LOGGER.isLoggable(Level.FINE)) {
                                            GeometryTypeConverterFactory.LOGGER.fine("Converting Geometry " + source.toString() + " to Point. This could be unsafe");
                                        }
                                        destGeometry /* !! */  = ((Geometry)source).getCentroid();
                                    }
                                    break block32;
                                }
                                if (!LineString.class.isAssignableFrom(target)) break block38;
                                if (!sourceGeometry.isEmpty()) break block39;
                                destGeometry /* !! */  = GeometryTypeConverterFactory.gFac.createLineString(new Coordinate[0]);
                                break block32;
                            }
                            if (!(source instanceof MultiLineString)) ** GOTO lbl-1000
                            string = (MultiLineString)source;
                            if (sourceGeometry.getNumGeometries() == 1) {
                                destGeometry /* !! */  = string.getGeometryN(0).copy();
                            } else lbl-1000:
                            // 2 sources

                            {
                                if (GeometryTypeConverterFactory.LOGGER.isLoggable(Level.FINE)) {
                                    GeometryTypeConverterFactory.LOGGER.fine("Converting Geometry " + source.toString() + " to LineString. This could be unsafe");
                                }
                                destGeometry /* !! */  = GeometryTypeConverterFactory.gFac.createLineString(this.getLineStringCoordinates(((Geometry)source).getCoordinates()));
                            }
                            break block32;
                        }
                        if (!Polygon.class.isAssignableFrom(target)) break block32;
                        if (!sourceGeometry.isEmpty()) break block40;
                        destGeometry /* !! */  = GeometryTypeConverterFactory.gFac.createLineString(new Coordinate[0]);
                        break block32;
                    }
                    if (!(source instanceof MultiPolygon)) ** GOTO lbl-1000
                    polygon = (MultiPolygon)source;
                    if (sourceGeometry.getNumGeometries() == 1) {
                        destGeometry /* !! */  = polygon.getGeometryN(0).copy();
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (GeometryTypeConverterFactory.LOGGER.isLoggable(Level.FINE)) {
                            GeometryTypeConverterFactory.LOGGER.fine("Converting Geometry " + source.toString() + " to Polygon. This could be unsafe");
                        }
                        coords = this.getPolygonCoordinates(((Geometry)source).getCoordinates());
                        destGeometry /* !! */  = GeometryTypeConverterFactory.gFac.createPolygon(GeometryTypeConverterFactory.gFac.createLinearRing(coords), new LinearRing[0]);
                    }
                }
                GeometryTypeConverterFactory.this.copyUserProperties(sourceGeometry, destGeometry /* !! */ );
                if (destGeometry /* !! */  != null) {
                    destGeometry /* !! */ .setSRID(sourceGeometry.getSRID());
                }
                return (T)destGeometry /* !! */ ;
            }
            return null;
        }

        private <T> T[] arrayCopy(T[] original, int length) {
            Class<?> arrayType = original.getClass().getComponentType();
            Object[] copy = (Object[])Array.newInstance(arrayType, length);
            System.arraycopy(original, 0, copy, 0, original.length < length ? original.length : length);
            return copy;
        }

        private Coordinate[] growCoordinatesNum(Coordinate[] input, int numpoints) {
            if (input.length < numpoints) {
                Object[] newCoordinates = this.arrayCopy(input, numpoints);
                Arrays.fill(newCoordinates, input.length, numpoints, input[0]);
                input = newCoordinates;
            }
            return input;
        }

        private Coordinate[] getLineStringCoordinates(Coordinate ... coordinates) {
            coordinates = this.growCoordinatesNum(coordinates, 2);
            return coordinates;
        }

        private Coordinate[] getPolygonCoordinates(Coordinate ... coordinates) {
            if (!(coordinates = this.growCoordinatesNum(coordinates, 4))[coordinates.length - 1].equals(coordinates[0])) {
                Coordinate[] newCoordinates = this.arrayCopy(coordinates, coordinates.length + 1);
                newCoordinates[newCoordinates.length - 1] = newCoordinates[0];
                coordinates = newCoordinates;
            }
            return coordinates;
        }
    }
}

