/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

public class EnumerationConverterFactory
implements ConverterFactory {
    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (String.class.equals(source) && target.isEnum() || source.isEnum() && String.class.equals(source)) {
            return new EnumConverter();
        }
        return null;
    }

    private static class EnumConverter
    implements Converter {
        private EnumConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source instanceof String) {
                String string = (String)source;
                if (target.isEnum()) {
                    return Enum.valueOf(target, string);
                }
            }
            if (source.getClass().isEnum() && String.class.equals(target)) {
                return (T)((Enum)source).name();
            }
            return null;
        }
    }
}

