/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import si.uom.SI;

public class DistanceBufferUtil {
    protected static Logger LOGGER = Logging.getLogger(DistanceBufferUtil.class);
    private static final Map<String, Double> UNITS_MAP = Map.ofEntries(Map.entry("kilometers", 1000.0), Map.entry("kilometer", 1000.0), Map.entry("km", 1000.0), Map.entry("m", 1.0), Map.entry("meter", 1.0), Map.entry("mm", 0.001), Map.entry("millimeter", 0.001), Map.entry("mi", 1609.344), Map.entry("miles", 1609.344), Map.entry("nm", 1852.0), Map.entry("feet", 0.3048), Map.entry("ft", 0.3048), Map.entry("in", 0.0254));

    public static double getDistanceInNativeUnits(DistanceBufferOperator operator2, Integer currentSRID) {
        if (currentSRID == null) {
            return operator2.getDistance();
        }
        try {
            SingleCRS crs = CRS.getHorizontalCRS(CRS.decode("EPSG:" + currentSRID));
            double distanceMeters = DistanceBufferUtil.getDistanceInMeters(operator2);
            if (crs instanceof GeographicCRS) {
                double sizeDegree = 110574.2727;
                Coordinate center = DistanceBufferUtil.getReferenceGeometryCentroid(operator2);
                if (center != null) {
                    double cosLat = Math.cos(Math.PI * center.y / 180.0);
                    double latAdjustment = Math.sqrt(1.0 + cosLat * cosLat) / Math.sqrt(2.0);
                    sizeDegree *= latAdjustment;
                }
                return distanceMeters / sizeDegree;
            }
            Unit<?> unit = crs.getCoordinateSystem().getAxis(0).getUnit();
            if (unit == null) {
                return distanceMeters;
            }
            UnitConverter converter = SI.METRE.getConverterTo(unit);
            return converter.convert(distanceMeters);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to turn the distance of spatial filter into native units, using it as a pure number instead", e);
            return operator2.getDistance();
        }
    }

    private static Coordinate getReferenceGeometryCentroid(DistanceBufferOperator operator2) {
        Geometry geom = operator2.getExpression1().evaluate(null, Geometry.class);
        if (geom == null) {
            geom = operator2.getExpression2().evaluate(null, Geometry.class);
        }
        if (geom == null) {
            return null;
        }
        return geom.getCentroid().getCoordinate();
    }

    public static double getDistanceInMeters(DistanceBufferOperator operator2) {
        double distance = operator2.getDistance();
        String units = operator2.getDistanceUnits();
        if (units == null || UNITS_MAP.get(units.toLowerCase()) == null) {
            return distance;
        }
        double factor = UNITS_MAP.get(units.toLowerCase());
        return distance * factor;
    }
}

