/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class CRSConverterFactory
implements ConverterFactory {
    private static final Logger LOGGER = Logging.getLogger(CRSConverterFactory.class);
    private static final CRSConverter STRING_TO_CRS = new CRSConverter();

    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (source == null || target == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("CRSConverterFactory can be applied from Strings to CRS only.");
            }
            return null;
        }
        if (CoordinateReferenceSystem.class.isAssignableFrom(target) && String.class.isAssignableFrom(source)) {
            return STRING_TO_CRS;
        }
        if (CoordinateReferenceSystem.class.isAssignableFrom(source) && String.class.isAssignableFrom(target)) {
            return STRING_TO_CRS;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("CRSConverterFactory can be applied from Strings to CRS  only.");
        }
        return null;
    }

    static class CRSConverter
    implements Converter {
        CRSConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            block16: {
                block15: {
                    if (source == null || target == null) {
                        return null;
                    }
                    if (source instanceof String) {
                        String input = (String)source;
                        if (CoordinateReferenceSystem.class.isAssignableFrom(target)) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("CRSConverter: Converting object of class " + source.getClass().getCanonicalName() + " to " + target.getCanonicalName());
                            }
                            input = input.trim();
                            try {
                                return (T)CRS.decode(input);
                            }
                            catch (Exception e) {
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                }
                                try {
                                    return (T)CRS.parseWKT(input);
                                }
                                catch (Exception e2) {
                                    if (!LOGGER.isLoggable(Level.FINE)) break block15;
                                    LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                                }
                            }
                        }
                    }
                }
                if (source instanceof CoordinateReferenceSystem) {
                    CoordinateReferenceSystem system = (CoordinateReferenceSystem)source;
                    if (String.class.isAssignableFrom(target)) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("CRSConverter: Converting object of class " + source.getClass().getCanonicalName() + " to " + target.getCanonicalName());
                        }
                        try {
                            return (T)system.toWKT();
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block16;
                            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                    }
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("CRSConverter: Unable to convert object of class " + source.getClass().getCanonicalName() + " to " + target.getCanonicalName());
            }
            return null;
        }
    }
}

