/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.lang.reflect.Array;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;

public class ArrayConverterFactory
implements ConverterFactory {
    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (source.isArray() && !target.isArray() && source.getComponentType().isAssignableFrom(target)) {
            return new ArrayToSingleConverter();
        }
        if (target.isArray() && !source.isArray() && target.getComponentType().isAssignableFrom(source)) {
            return new SingleToArrayConverter();
        }
        if (source.isArray() && target.isArray()) {
            return new ArrayToArrayConverter();
        }
        return null;
    }

    private static class ArrayToSingleConverter
    implements Converter {
        private ArrayToSingleConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (Array.getLength(source) != 1) {
                return null;
            }
            return target.cast(Array.get(source, 0));
        }
    }

    private static class SingleToArrayConverter
    implements Converter {
        private SingleToArrayConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            Object result = Array.newInstance(target.getComponentType(), 1);
            Array.set(result, 0, source);
            return target.cast(result);
        }
    }

    private static class ArrayToArrayConverter
    implements Converter {
        private ArrayToArrayConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            int arrLength = Array.getLength(source);
            Class<?> elementType = target.getComponentType();
            Object result = Array.newInstance(elementType, arrLength);
            for (int count = 0; count < arrLength; ++count) {
                Object sourceElement = Array.get(source, count);
                Object converted = Converters.convert(sourceElement, elementType);
                if (sourceElement != null && converted == null) {
                    return null;
                }
                Array.set(result, count, converted);
            }
            return target.cast(result);
        }
    }
}

