/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;

public class ReTypingFeatureIterator
implements SimpleFeatureIterator {
    SimpleFeatureIterator delegate;
    SimpleFeatureType target;
    AttributeDescriptor[] types;
    SimpleFeatureBuilder builder;

    public ReTypingFeatureIterator(SimpleFeatureIterator delegate, SimpleFeatureType source, SimpleFeatureType target) {
        this.delegate = delegate;
        this.target = target;
        this.types = this.typeAttributes(source, target);
        this.builder = new SimpleFeatureBuilder(target);
    }

    public SimpleFeatureIterator getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public SimpleFeature next() {
        SimpleFeature next = (SimpleFeature)this.delegate.next();
        String id = next.getID();
        try {
            for (AttributeDescriptor type : this.types) {
                String xpath = type.getLocalName();
                this.builder.add(next.getAttribute(xpath));
            }
            this.builder.featureUserData(next);
            return this.builder.buildFeature(id);
        }
        catch (IllegalAttributeException e) {
            throw new RuntimeException(e);
        }
    }

    protected AttributeDescriptor[] typeAttributes(SimpleFeatureType original, SimpleFeatureType target) {
        if (target.equals(original)) {
            throw new IllegalArgumentException("FeatureReader allready produces contents with the correct schema");
        }
        if (target.getAttributeCount() > original.getAttributeCount()) {
            throw new IllegalArgumentException("Unable to retype  FeatureReader<SimpleFeatureType, SimpleFeature> (origional does not cover requested type)");
        }
        AttributeDescriptor[] types = new AttributeDescriptor[target.getAttributeCount()];
        for (int i = 0; i < target.getAttributeCount(); ++i) {
            AttributeDescriptor attrib = target.getDescriptor(i);
            String xpath = attrib.getLocalName();
            types[i] = attrib;
            if (attrib.equals(original.getDescriptor(xpath))) continue;
            throw new IllegalArgumentException("Unable to retype  FeatureReader<SimpleFeatureType, SimpleFeature> (origional does not cover " + xpath + ")");
        }
        return types;
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

