/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;
import org.geotools.data.shapefile.files.FileReader;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.files.StreamLogging;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.util.NIOUtilities;
import org.geotools.util.logging.Logging;

public class IndexFile
implements FileReader,
AutoCloseable {
    private static final Logger LOGGER = Logging.getLogger(IndexFile.class);
    private static final int RECS_IN_BUFFER = 2000;
    private boolean useMemoryMappedBuffer;
    private FileChannel channel;
    private int channelOffset;
    private ByteBuffer buf = null;
    private int lastIndex = -1;
    private int recOffset;
    private int recLen;
    private ShapefileHeader header = null;
    private int[] content;
    private StreamLogging streamLogger = new StreamLogging("IndexFile");
    private volatile boolean closed = false;

    public IndexFile(ShpFiles shpFiles, boolean useMemoryMappedBuffer) throws IOException {
        this.useMemoryMappedBuffer = useMemoryMappedBuffer;
        this.streamLogger.open();
        ReadableByteChannel byteChannel = shpFiles.getReadChannel(ShpFileType.SHX, this);
        try {
            if (byteChannel instanceof FileChannel) {
                FileChannel fileChannel;
                this.channel = fileChannel = (FileChannel)byteChannel;
                if (useMemoryMappedBuffer) {
                    LOGGER.finest("Memory mapping file...");
                    this.buf = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size());
                    this.channelOffset = 0;
                } else {
                    LOGGER.finest("Reading from file...");
                    this.buf = NIOUtilities.allocate(16000);
                    this.channel.read(this.buf);
                    this.buf.flip();
                    this.channelOffset = 0;
                }
                this.header = new ShapefileHeader();
                this.header.read(this.buf, true);
            } else {
                LOGGER.finest("Loading all shx...");
                this.readHeader(byteChannel);
                this.readRecords(byteChannel);
                byteChannel.close();
            }
        }
        catch (Throwable e) {
            if (byteChannel != null) {
                byteChannel.close();
            }
            throw (IOException)new IOException(e.getLocalizedMessage()).initCause(e);
        }
    }

    public ShapefileHeader getHeader() {
        return this.header;
    }

    private void check() {
        if (this.closed) {
            throw new IllegalStateException("Index file has been closed");
        }
    }

    private void readHeader(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = NIOUtilities.allocate(100);
        try {
            while (buffer.remaining() > 0) {
                channel.read(buffer);
            }
            buffer.flip();
            this.header = new ShapefileHeader();
            this.header.read(buffer, true);
        }
        finally {
            NIOUtilities.clean(buffer, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRecords(ReadableByteChannel channel) throws IOException {
        this.check();
        int remaining = this.header.getFileLength() * 2 - 100;
        ByteBuffer buffer = NIOUtilities.allocate(remaining);
        try {
            buffer.order(ByteOrder.BIG_ENDIAN);
            while (buffer.remaining() > 0) {
                channel.read(buffer);
            }
            buffer.flip();
            int records = remaining / 4;
            this.content = new int[records];
            IntBuffer ints = buffer.asIntBuffer();
            ints.get(this.content);
        }
        finally {
            NIOUtilities.clean(buffer, false);
        }
    }

    private void readRecord(int index) throws IOException {
        this.check();
        int pos = 100 + index * 8;
        if (!(this.useMemoryMappedBuffer || pos - this.channelOffset >= 0 && this.channelOffset + this.buf.limit() > pos && this.lastIndex != -1)) {
            LOGGER.finest("Filling buffer...");
            this.channelOffset = pos;
            this.channel.position(pos);
            this.buf.clear();
            this.channel.read(this.buf);
            this.buf.flip();
        }
        this.buf.position(pos - this.channelOffset);
        this.recOffset = this.buf.getInt();
        this.recLen = this.buf.getInt();
        this.lastIndex = index;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
            this.streamLogger.close();
            NIOUtilities.clean(this.buf, this.useMemoryMappedBuffer);
        }
        this.buf = null;
        this.content = null;
        this.channel = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public int getRecordCount() {
        return (this.header.getFileLength() * 2 - 100) / 8;
    }

    public int getOffset(int index) throws IOException {
        int ret = -1;
        if (this.channel != null) {
            if (this.lastIndex != index) {
                this.readRecord(index);
            }
            ret = this.recOffset;
        } else {
            ret = this.content[2 * index];
        }
        return ret;
    }

    public int getOffsetInBytes(int index) throws IOException {
        return this.getOffset(index) * 2;
    }

    public int getContentLength(int index) throws IOException {
        int ret = -1;
        if (this.channel != null) {
            if (this.lastIndex != index) {
                this.readRecord(index);
            }
            ret = this.recLen;
        } else {
            ret = this.content[2 * index + 1];
        }
        return ret;
    }

    @Override
    public String id() {
        return this.getClass().getName();
    }
}

