/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.directory;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.data.directory.DirectoryTypeCache;
import org.geotools.util.logging.Logging;

class FactoryAdapter {
    static final Logger LOGGER = Logging.getLogger(DirectoryTypeCache.class);
    DataStoreFactorySpi factory;
    DataAccessFactory.Param fileParam;
    DataAccessFactory.Param nsParam;

    public FactoryAdapter(DataStoreFactorySpi factory, DataAccessFactory.Param fileParam, DataAccessFactory.Param nsParam) {
        this.factory = factory;
        this.fileParam = fileParam;
        this.nsParam = nsParam;
    }

    public DataStore getStore(File curr, URI namespaceURI) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.nsParam != null) {
            if (String.class.isAssignableFrom(this.nsParam.type)) {
                params.put(this.nsParam.key, namespaceURI.toString());
            } else if (URI.class.isAssignableFrom(this.nsParam.type)) {
                params.put(this.nsParam.key, namespaceURI);
            } else {
                throw new RuntimeException("Don't know how to handle namespace param: " + this.nsParam.key);
            }
        }
        if (File.class.isAssignableFrom(this.fileParam.type)) {
            params.put(this.fileParam.key, curr);
        } else if (URL.class.isAssignableFrom(this.fileParam.type)) {
            params.put(this.fileParam.key, curr.toURI().toURL());
        }
        try {
            if (this.factory.canProcess(params)) {
                return this.factory.createDataStore(params);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Factory " + String.valueOf(this.factory.getClass()) + " reports it can process parameters, but then fails during creation", e);
        }
        return null;
    }

    public String toString() {
        return this.factory.getClass().toString();
    }
}

