/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.collection.SpatialIndexFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.feature.collection.MaxSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class SpatialIndexFeatureSource
implements SimpleFeatureSource {
    SpatialIndexFeatureCollection contents;
    private static final Set<Class> supportedFilterTypes = new HashSet<Class>(Arrays.asList(BBOX.class, Contains.class, Crosses.class, DWithin.class, Equals.class, Intersects.class, Overlaps.class, Touches.class, Within.class));

    public SpatialIndexFeatureSource(SpatialIndexFeatureCollection original) {
        this.contents = original;
    }

    @Override
    public void addFeatureListener(FeatureListener listener) {
    }

    @Override
    public void removeFeatureListener(FeatureListener listener) {
    }

    public DataStore getDataStore() {
        return null;
    }

    @Override
    public ReferencedEnvelope getBounds() throws IOException {
        return this.contents.getBounds();
    }

    @Override
    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.getFeatures(query).getBounds();
    }

    @Override
    public int getCount(Query query) throws IOException {
        return this.getFeatures(query).size();
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.contents.getSchema();
    }

    @Override
    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.contents;
    }

    @Override
    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        Query query = new Query(this.getSchema().getName().getLocalPart(), filter);
        return this.getFeatures(query);
    }

    @Override
    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        Envelope bounds = this.getEnvelope(query.getFilter());
        return this.getFeatureCollection(query, bounds);
    }

    private SimpleFeatureCollection getFeatureCollection(Query query, Envelope bounds) throws IOException {
        SimpleFeatureType schema;
        SimpleFeatureType target;
        Object copy;
        int offset;
        int n = offset = ((Query)(query = DataUtilities.resolvePropertyNames((Query)query, this.getSchema()))).getStartIndex() != null ? ((Query)query).getStartIndex() : 0;
        if (offset > 0 && ((Query)query).getSortBy() == null) {
            if (!this.getQueryCapabilities().supportsSorting(((Query)query).getSortBy())) {
                throw new IllegalStateException("Feature source does not support this sorting so there is no way a stable paging (offset/limit) can be performed");
            }
            copy = new Query((Query)query);
            ((Query)copy).setSortBy(SortBy.NATURAL_ORDER);
            query = copy;
        }
        if (((Query)query).getFilter() != null && ((Query)query).getFilter().equals(Filter.EXCLUDE)) {
            return new EmptyFeatureCollection(this.getSchema());
        }
        if (((Query)query).getFilter() != null && ((Query)query).getFilter().equals(Filter.INCLUDE)) {
            copy = this.contents;
        }
        SimpleFeatureCollection collection = ((Query)query).getFilter() != null && ((Query)query).getFilter().equals(Filter.INCLUDE) ? this.contents : this.contents.subCollection(((Query)query).getFilter());
        if (((Query)query).getCoordinateSystemReproject() != null) {
            collection = new ReprojectingFeatureCollection(collection, ((Query)query).getCoordinateSystemReproject());
        }
        if (((Query)query).getSortBy() != null && ((Query)query).getSortBy().length != 0) {
            SimpleFeature[] array = collection.toArray(new SimpleFeature[collection.size()]);
            for (SortBy sortBy : ((Query)query).getSortBy()) {
                Comparator<SimpleFeature> comparator = DataUtilities.sortComparator(sortBy);
                Arrays.sort(array, comparator);
            }
            ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>(Arrays.asList(array));
            collection = new ListFeatureCollection(this.getSchema(), list);
        }
        if (offset > 0 || !((Query)query).isMaxFeaturesUnlimited()) {
            long max = Long.MAX_VALUE;
            if (!((Query)query).isMaxFeaturesUnlimited()) {
                max = ((Query)query).getMaxFeatures();
            }
            collection = new MaxSimpleFeatureCollection(collection, offset, max);
        }
        if (((Query)query).getPropertyNames() != Query.ALL_NAMES && !(target = SimpleFeatureTypeBuilder.retype(schema = (SimpleFeatureType)collection.getSchema(), ((Query)query).getPropertyNames())).equals(schema)) {
            collection = new ReTypingFeatureCollection(collection, target);
        }
        return collection;
    }

    Envelope getEnvelope(Filter filter) {
        BinarySpatialOperator gf;
        Envelope result = new Envelope();
        if (filter instanceof And) {
            And and = (And)filter;
            Envelope bounds = new Envelope();
            for (Filter f : and.getChildren()) {
                Envelope e = this.getEnvelope(f);
                if (e == null) {
                    return null;
                }
                bounds.expandToInclude(e);
            }
            result = bounds;
        } else if (filter instanceof BinarySpatialOperator && supportedFilterTypes.contains((gf = (BinarySpatialOperator)filter).getClass())) {
            Expression lg = gf.getExpression1();
            Expression rg = gf.getExpression2();
            if (lg instanceof Literal) {
                Literal literal1 = (Literal)lg;
                Geometry g = (Geometry)literal1.getValue();
                if (rg instanceof PropertyName) {
                    result = g.getEnvelopeInternal();
                }
            } else if (rg instanceof Literal) {
                Literal literal = (Literal)rg;
                Geometry g = (Geometry)literal.getValue();
                if (lg instanceof PropertyName) {
                    result = g.getEnvelopeInternal();
                }
            }
        }
        return result;
    }

    @Override
    public ResourceInfo getInfo() {
        return null;
    }

    @Override
    public Name getName() {
        return this.contents.getSchema().getName();
    }

    @Override
    public QueryCapabilities getQueryCapabilities() {
        return new QueryCapabilities(){

            @Override
            public boolean isOffsetSupported() {
                return true;
            }
        };
    }

    @Override
    public Set<RenderingHints.Key> getSupportedHints() {
        return new HashSet<RenderingHints.Key>();
    }
}

