/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.api.data.DelegatingFeatureReader;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.util.Classes;

public class ReTypeFeatureReader
implements DelegatingFeatureReader<SimpleFeatureType, SimpleFeature> {
    FeatureReader<SimpleFeatureType, SimpleFeature> reader;
    SimpleFeatureType featureType;
    AttributeDescriptor[] types;
    SimpleFeatureBuilder builder;
    boolean clone;

    public ReTypeFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeatureType featureType) {
        this(reader, featureType, true);
    }

    public ReTypeFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeatureType featureType, boolean clone) {
        this.reader = reader;
        this.featureType = featureType;
        this.clone = clone;
        this.types = this.typeAttributes(featureType, reader.getFeatureType());
        this.builder = new SimpleFeatureBuilder(featureType);
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getDelegate() {
        return this.reader;
    }

    protected AttributeDescriptor[] typeAttributes(SimpleFeatureType target, SimpleFeatureType origional) {
        if (FeatureTypes.equalsExact(origional, target)) {
            throw new IllegalArgumentException("FeatureReader allready produces contents with the correct schema");
        }
        if (target.getAttributeCount() > origional.getAttributeCount()) {
            throw new IllegalArgumentException("Unable to retype  FeatureReader<SimpleFeatureType, SimpleFeature> (origional does not cover requested type)");
        }
        AttributeDescriptor[] types = new AttributeDescriptor[target.getAttributeCount()];
        for (int i = 0; i < target.getAttributeCount(); ++i) {
            Class<?> checkBinding;
            AttributeDescriptor attrib = target.getDescriptor(i);
            String xpath = attrib.getLocalName();
            types[i] = attrib;
            AttributeDescriptor check = origional.getDescriptor(xpath);
            Class<?> targetBinding = attrib.getType().getBinding();
            if (targetBinding.isAssignableFrom(checkBinding = check.getType().getBinding())) continue;
            throw new IllegalArgumentException("Unable to retype FeatureReader for " + xpath + " as " + Classes.getShortName(checkBinding) + " cannot be assigned to " + Classes.getShortName(targetBinding));
        }
        return types;
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.reader == null) {
            throw new IOException("FeatureReader has been closed");
        }
        SimpleFeature next = this.reader.next();
        String id = next.getID();
        for (AttributeDescriptor type : this.types) {
            String xpath = type.getLocalName();
            if (this.clone) {
                this.builder.add(DataUtilities.duplicate(next.getAttribute(xpath)));
                continue;
            }
            this.builder.add(next.getAttribute(xpath));
        }
        SimpleFeature feature = this.builder.buildFeature(id);
        if (next.hasUserData()) {
            feature.getUserData().putAll(next.getUserData());
        }
        return feature;
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.reader.hasNext();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.featureType = null;
            this.types = null;
        }
    }
}

