/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;
import org.geotools.api.data.CloseableIterator;
import org.geotools.util.logging.Logging;

public class DefaultCloseableIterator<T>
implements CloseableIterator<T> {
    private static final Logger LOGGER = Logging.getLogger(DefaultCloseableIterator.class);
    protected final Iterator<T> wrapped;
    protected Closeable closeableItem;

    public DefaultCloseableIterator(Iterator<T> wrapped) {
        Closeable closeable;
        this.wrapped = wrapped;
        this.closeableItem = wrapped instanceof Closeable ? (closeable = (Closeable)((Object)wrapped)) : null;
    }

    public DefaultCloseableIterator(Iterator<T> wrapped, Closeable closeable) {
        this.wrapped = wrapped;
        this.closeableItem = closeable;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.wrapped.hasNext();
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    @Override
    public T next() {
        return this.wrapped.next();
    }

    @Override
    public void remove() {
        this.wrapped.remove();
    }

    @Override
    public void close() {
        try {
            if (this.closeableItem != null) {
                this.closeableItem.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeableItem = null;
        }
    }

    protected void finalize() {
        if (this.closeableItem != null) {
            try {
                this.close();
            }
            finally {
                LOGGER.warning("CloseableIterator need to be closed by the client. There is code not closing it.\nAuto closing at finalize().");
            }
        }
    }
}

