/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.util;

import java.io.PrintStream;
import java.io.PrintWriter;

public class ImagingException
extends RuntimeException {
    private Throwable cause = null;

    public ImagingException() {
    }

    public ImagingException(String message) {
        super(message);
    }

    public ImagingException(Throwable cause) {
        this.cause = cause;
    }

    public ImagingException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public Throwable getRootCause() {
        Throwable rootCause = this.cause;
        Throwable atop = this;
        while (rootCause != atop && rootCause != null) {
            atop = rootCause;
            if ((rootCause = rootCause.getCause()) != null) continue;
            rootCause = atop;
        }
        return rootCause;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            super.printStackTrace(s);
            boolean is14 = false;
            try {
                String version = System.getProperty("java.version");
                is14 = version.indexOf("1.4") >= 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!is14 && this.cause != null) {
                s.println("Caused by:");
                this.cause.printStackTrace(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            super.printStackTrace(s);
            boolean is14 = false;
            try {
                String version = System.getProperty("java.version");
                is14 = version.indexOf("1.4") >= 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!is14 && this.cause != null) {
                s.println("Caused by:");
                this.cause.printStackTrace(s);
            }
        }
    }
}

