/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.serialize;

import java.awt.RenderingHints;
import java.io.Serializable;
import org.eclipse.imagen.media.serialize.JaiI18N;
import org.eclipse.imagen.media.serialize.SerializableState;
import org.eclipse.imagen.media.serialize.SerializerFactory;

public abstract class SerializableStateImpl
implements SerializableState {
    protected Class theClass;
    protected transient Object theObject;

    public static Class[] getSupportedClasses() {
        throw new RuntimeException(JaiI18N.getString("SerializableStateImpl0"));
    }

    public static boolean permitsSubclasses() {
        return false;
    }

    protected SerializableStateImpl(Class c, Object o, RenderingHints h) {
        if (c == null || o == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableStateImpl1"));
        }
        boolean isInterface = c.isInterface();
        if (isInterface && !c.isInstance(o)) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableStateImpl2"));
        }
        if (!isInterface) {
            if (!c.equals(o.getClass())) {
                throw new IllegalArgumentException(JaiI18N.getString("SerializableStateImpl3"));
            }
            if (!c.isAssignableFrom(o.getClass())) {
                throw new IllegalArgumentException(JaiI18N.getString("SerializableStateImpl4"));
            }
        }
        this.theClass = c;
        this.theObject = o;
    }

    @Override
    public Class getObjectClass() {
        return this.theClass;
    }

    @Override
    public Object getObject() {
        return this.theObject;
    }

    protected Object getSerializableForm(Object object) {
        if (object instanceof Serializable) {
            return object;
        }
        if (object != null) {
            try {
                object = SerializerFactory.getState(object, null);
            }
            catch (Exception e) {
                object = null;
            }
        }
        return object;
    }

    protected Object getDeserializedFrom(Object object) {
        if (object instanceof SerializableState) {
            object = ((SerializableState)object).getObject();
        }
        return object;
    }
}

