/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.serialize;

import java.awt.RenderingHints;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.imagen.media.serialize.JaiI18N;
import org.eclipse.imagen.media.serialize.SerializableStateImpl;

public class DataBufferState
extends SerializableStateImpl {
    private transient DataBuffer dataBuffer;

    public static Class[] getSupportedClasses() {
        return new Class[]{DataBufferByte.class, DataBufferShort.class, DataBufferUShort.class, DataBufferInt.class, DataBufferFloat.class, DataBufferDouble.class};
    }

    public DataBufferState(Class c, Object o, RenderingHints h) {
        super(c, o, h);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        DataBuffer dataBuffer = (DataBuffer)this.theObject;
        int dataType = dataBuffer.getDataType();
        out.writeInt(dataType);
        out.writeObject(dataBuffer.getOffsets());
        out.writeInt(dataBuffer.getSize());
        Object dataArray = null;
        switch (dataType) {
            case 0: {
                dataArray = ((DataBufferByte)dataBuffer).getBankData();
                break;
            }
            case 2: {
                dataArray = ((DataBufferShort)dataBuffer).getBankData();
                break;
            }
            case 1: {
                dataArray = ((DataBufferUShort)dataBuffer).getBankData();
                break;
            }
            case 3: {
                dataArray = ((DataBufferInt)dataBuffer).getBankData();
                break;
            }
            case 4: {
                dataArray = ((DataBufferFloat)dataBuffer).getBankData();
                break;
            }
            case 5: {
                dataArray = ((DataBufferDouble)dataBuffer).getBankData();
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("DataBufferState0"));
            }
        }
        out.writeObject(dataArray);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        DataBuffer dataBuffer = null;
        int dataType = -1;
        int[] offsets = null;
        int size = -1;
        Object dataArray = null;
        dataType = in.readInt();
        offsets = (int[])in.readObject();
        size = in.readInt();
        dataArray = in.readObject();
        switch (dataType) {
            case 0: {
                dataBuffer = new DataBufferByte((byte[][])dataArray, size, offsets);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort((short[][])dataArray, size, offsets);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort((short[][])dataArray, size, offsets);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt((int[][])dataArray, size, offsets);
                break;
            }
            case 4: {
                dataBuffer = new DataBufferFloat((float[][])dataArray, size, offsets);
                break;
            }
            case 5: {
                dataBuffer = new DataBufferDouble((double[][])dataArray, size, offsets);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("DataBufferState0"));
            }
        }
        this.theObject = dataBuffer;
    }
}

