/*
 * Decompiled with CFR 0.152.
 */
package com.sigpwned.chardet4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public final class ByteStreams {
    private ByteStreams() {
    }

    public static byte[] readNBytes(InputStream in, int count) throws IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        if (count < 0) {
            throw new IllegalArgumentException("count must not be negative");
        }
        byte[] buf = new byte[count];
        if (count == 0) {
            return buf;
        }
        int len = 0;
        int nread = in.read(buf);
        while (nread != -1 && (len += nread) != buf.length) {
            nread = in.read(buf, len, buf.length - len);
        }
        if (len == buf.length) {
            return buf;
        }
        return Arrays.copyOf(buf, len);
    }
}

