/*
 * Decompiled with CFR 0.152.
 */
package com.sigpwned.chardet4j.io;

import com.sigpwned.chardet4j.ByteOrderMark;
import com.sigpwned.chardet4j.util.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Optional;

public final class BomAwareInputStream
extends FilterInputStream {
    private final ByteOrderMark bom;

    public static BomAwareInputStream detect(InputStream in) throws IOException {
        byte[] buf = ByteStreams.readNBytes(in, ByteOrderMark.MAX_BYTE_LENGTH);
        ByteOrderMark bom = ByteOrderMark.detect(buf).orElse(null);
        if (bom == null) {
            return new BomAwareInputStream(new SequenceInputStream(new ByteArrayInputStream(buf), in), null);
        }
        int bomlen = bom.length();
        if (bomlen == buf.length) {
            return new BomAwareInputStream(in, bom);
        }
        return new BomAwareInputStream(new SequenceInputStream(new ByteArrayInputStream(buf, bomlen, buf.length - bomlen), in), bom);
    }

    private BomAwareInputStream(InputStream delegate, ByteOrderMark bom) {
        super(delegate);
        this.bom = bom;
    }

    public Optional<ByteOrderMark> bom() {
        return Optional.ofNullable(this.bom);
    }
}

