/*
 * Decompiled with CFR 0.152.
 */
package com.sigpwned.chardet4j;

import com.sigpwned.chardet4j.ByteOrderMark;
import com.sigpwned.chardet4j.com.ibm.icu.text.CharsetDetector;
import com.sigpwned.chardet4j.io.BomAwareInputStream;
import com.sigpwned.chardet4j.io.DecodedInputStreamReader;
import com.sigpwned.chardet4j.util.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class Chardet {
    private static final int MIN_CONFIDENCE = 0;
    private static final int MAX_CONFIDENCE = 100;
    private static final int DECLARED_ENCODING_BUMP = Optional.ofNullable(System.getProperty("chardet4j.detect.bump")).map(Integer::parseInt).orElse(10);
    public static final int DECODE_DETECT_BUFSIZE = Optional.ofNullable(System.getProperty("chardet4j.detect.bufsize")).map(Integer::parseInt).orElse(8192);

    private Chardet() {
    }

    public static Optional<Charset> detectCharset(byte[] data) {
        return Chardet.detectCharset(data, null);
    }

    public static Optional<Charset> detectCharset(byte[] data, String declaredEncoding) {
        if (data == null) {
            throw new NullPointerException();
        }
        return Chardet.detectCharset(data, data.length, declaredEncoding);
    }

    public static Optional<Charset> detectCharset(byte[] data, int len, String declaredEncoding) {
        return Chardet.detectCharset(data, 0, len, declaredEncoding);
    }

    public static Optional<Charset> detectCharset(byte[] data, int off, int len, String declaredEncoding) {
        return Chardet.detectCharsetName(data, off, len, declaredEncoding).map(Charset::forName);
    }

    public static Optional<String> detectCharsetName(byte[] data) {
        return Chardet.detectCharsetName(data, null);
    }

    public static Optional<String> detectCharsetName(byte[] data, String declaredEncoding) {
        if (data == null) {
            throw new NullPointerException();
        }
        return Chardet.detectCharsetName(data, data.length, declaredEncoding);
    }

    public static Optional<String> detectCharsetName(byte[] data, int len, String declaredEncoding) {
        return Chardet.detectCharsetName(data, 0, len, declaredEncoding);
    }

    public static Optional<String> detectCharsetName(byte[] data, int off, int len, String declaredEncoding) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
        if (off + len > data.length) {
            throw new ArrayIndexOutOfBoundsException(off + len);
        }
        Optional<ByteOrderMark> maybeBom = ByteOrderMark.detect(data, off, len);
        if (maybeBom.isPresent()) {
            return maybeBom.map(ByteOrderMark::getCharsetName);
        }
        CharsetDetector chardet = new CharsetDetector();
        if (off == 0 && len == data.length) {
            chardet.setText(data);
        } else {
            try {
                chardet.setText(new ByteArrayInputStream(data, off, len));
            }
            catch (IOException e) {
                throw new UncheckedIOException("unexpected exception when reading from byte array", e);
            }
        }
        List matches = Arrays.stream(chardet.detectAll()).map(mi -> {
            String name = mi.getName();
            int confidence = mi.getConfidence();
            if (declaredEncoding != null && name.equalsIgnoreCase(declaredEncoding)) {
                confidence = Math.min(confidence + DECLARED_ENCODING_BUMP, 100);
            }
            return ChardetMatch.of(name, confidence);
        }).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        if (matches.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((ChardetMatch)matches.get(0)).getName());
    }

    public static DecodedInputStreamReader decode(InputStream input, Charset defaultCharset) throws IOException {
        return Chardet.decode(input, null, defaultCharset);
    }

    public static DecodedInputStreamReader decode(InputStream input, String declaredEncoding, Charset defaultCharset) throws IOException {
        if (input == null) {
            throw new NullPointerException();
        }
        if (defaultCharset == null) {
            throw new NullPointerException();
        }
        BomAwareInputStream bomed = BomAwareInputStream.detect(input);
        if (bomed.bom().isPresent()) {
            return new DecodedInputStreamReader((InputStream)bomed, bomed.bom().get().getCharset());
        }
        byte[] buf = ByteStreams.readNBytes(bomed, DECODE_DETECT_BUFSIZE);
        Charset charset = Chardet.detectCharset(buf, declaredEncoding).orElse(defaultCharset);
        return new DecodedInputStreamReader((InputStream)new SequenceInputStream(new ByteArrayInputStream(buf), bomed), charset);
    }

    public static String decode(byte[] data, Charset defaultCharset) {
        return Chardet.decode(data, null, defaultCharset);
    }

    public static String decode(byte[] data, String declaredEncoding, Charset defaultCharset) {
        if (data == null) {
            throw new NullPointerException();
        }
        return Chardet.decode(data, data.length, declaredEncoding, defaultCharset);
    }

    public static String decode(byte[] data, int len, String declaredEncoding, Charset defaultCharset) {
        return Chardet.decode(data, 0, len, declaredEncoding, defaultCharset);
    }

    /*
     * Exception decompiling
     */
    public static String decode(byte[] data, int off, int len, String declaredEncoding, Charset defaultCharset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class ChardetMatch
    implements Comparable<ChardetMatch> {
        private final String name;
        private final int confidence;

        public static ChardetMatch of(String name, int confidence) {
            return new ChardetMatch(name, confidence);
        }

        public ChardetMatch(String name, int confidence) {
            if (name == null) {
                throw new NullPointerException();
            }
            if (confidence < 0 || confidence > 100) {
                throw new IllegalArgumentException("confidence out of range " + confidence);
            }
            this.name = name;
            this.confidence = confidence;
        }

        public String getName() {
            return this.name;
        }

        public int getConfidence() {
            return this.confidence;
        }

        public int hashCode() {
            return Objects.hash(this.confidence, this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChardetMatch other = (ChardetMatch)obj;
            return this.confidence == other.confidence && Objects.equals(this.name, other.name);
        }

        public String toString() {
            return "PossibleMatch [name=" + this.name + ", confidence=" + this.confidence + "]";
        }

        @Override
        public int compareTo(ChardetMatch o) {
            return Integer.compare(this.getConfidence(), o.getConfidence());
        }
    }
}

