/*
 * Decompiled with CFR 0.152.
 */
package com.sigpwned.chardet4j;

import com.sigpwned.chardet4j.io.BomAwareInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public enum ByteOrderMark {
    UTF_8(new byte[]{-17, -69, -65}, StandardCharsets.UTF_8, "UTF-8"),
    UTF_16BE(new byte[]{-2, -1}, StandardCharsets.UTF_16BE, "UTF-16BE"),
    UTF_16LE(new byte[]{-1, -2}, StandardCharsets.UTF_16LE, "UTF-16LE"),
    UTF_32BE(new byte[]{0, 0, -2, -1}, null, "UTF-32BE"),
    UTF_32LE(new byte[]{-1, -2, 0, 0}, null, "UTF-32LE"),
    UTF_1(new byte[]{-9, 100, 76}, null, "UTF-1"),
    UTF_EBCDIC(new byte[]{-35, 115, 102, 115}, null, "UTF-EBCDIC"),
    GB_18030(new byte[]{-124, 49, -107, 51}, null, "GB-18030");

    public static final int MAX_BYTE_LENGTH;
    private static final ByteOrderMark[] VALUES;
    private final byte[] bytes;
    private final Charset standardCharset;
    private final String charsetName;
    private volatile AtomicReference<Charset> charset;

    public static BomAwareInputStream detect(InputStream in) throws IOException {
        return BomAwareInputStream.detect(in);
    }

    public static Optional<ByteOrderMark> detect(byte[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        return ByteOrderMark.detect(data, data.length);
    }

    public static Optional<ByteOrderMark> detect(byte[] data, int len) {
        return ByteOrderMark.detect(data, 0, len);
    }

    public static Optional<ByteOrderMark> detect(byte[] data, int off, int len) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
        if (off + len > data.length) {
            throw new ArrayIndexOutOfBoundsException(off + len);
        }
        for (ByteOrderMark value : VALUES) {
            byte[] bom = value.getBytes();
            int bomlen = value.getBytes().length;
            if (off + bomlen > len || !ByteOrderMark.equals(data, off, off + bomlen, bom, 0, bomlen)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private static boolean equals(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
        ByteOrderMark.rangeCheck(a.length, aFromIndex, aToIndex);
        ByteOrderMark.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        int length = aLength;
        for (int i = 0; i < length; ++i) {
            if (a[aFromIndex + i] == b[bFromIndex + i]) continue;
            return false;
        }
        return true;
    }

    private static void rangeCheck(int arrayLength, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLength) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    private ByteOrderMark(byte[] bytes, Charset standardCharset, String charsetName) {
        this.bytes = Objects.requireNonNull(bytes);
        this.standardCharset = standardCharset;
        this.charsetName = Objects.requireNonNull(charsetName);
        if (standardCharset != null) {
            this.charset = new AtomicReference<Charset>(standardCharset);
        }
    }

    byte[] getBytes() {
        return this.bytes;
    }

    public int length() {
        return this.bytes.length;
    }

    public Charset getCharset() {
        return this.getCharsetIfSupported().orElseThrow(() -> new UnsupportedCharsetException(this.charsetName));
    }

    public Optional<Charset> getCharsetIfSupported() {
        if (this.standardCharset != null) {
            return Optional.of(this.standardCharset);
        }
        if (this.charset == null) {
            Charset c;
            try {
                c = Charset.forName(this.charsetName);
            }
            catch (IllegalCharsetNameException e) {
                c = null;
            }
            catch (UnsupportedCharsetException e) {
                c = null;
            }
            this.charset = new AtomicReference<Charset>(c);
        }
        return Optional.ofNullable(this.charset.get());
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    static {
        MAX_BYTE_LENGTH = Arrays.stream(ByteOrderMark.values()).mapToInt(bom -> bom.getBytes().length).max().getAsInt();
        VALUES = Arrays.copyOf(ByteOrderMark.values(), ByteOrderMark.values().length);
        Arrays.sort(VALUES, Comparator.comparingInt(bom -> bom.getBytes().length).reversed().thenComparing(ByteOrderMark::getCharsetName));
    }
}

