/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.xml;

import com.scythebill.xml.BaseNodeParser;
import com.scythebill.xml.NodeParser;
import com.scythebill.xml.ParseContext;
import com.scythebill.xml.ParseContextImpl;
import com.scythebill.xml.ParseContextWrapper;
import com.scythebill.xml.ParseErrorUtils;
import com.scythebill.xml.ParserManager;
import java.io.IOException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class TreeBuilder<T> {
    final Class<?> _rootClass;
    private EntityResolver _entityResolver;
    private final ParserManager _manager;
    private static final Logger _LOG = Logger.getLogger(TreeBuilder.class.getName());

    public TreeBuilder() {
        this(null, null);
    }

    public TreeBuilder(ParserManager manager, Class<T> rootClass) {
        this._manager = manager == null ? new ParserManager() : (ParserManager)manager.clone();
        this._rootClass = rootClass;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this._entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public T parse(InputSource source) throws IOException, SAXException {
        ParseContextImpl context = new ParseContextImpl();
        return this.parse(source, context);
    }

    public T parse(InputSource source, ParseContext context) throws IOException, SAXException {
        return this.parse(source, context, null);
    }

    public T parse(InputSource source, NodeParser rootParser) throws IOException, SAXException {
        return this.parse(source, new ParseContextImpl(), rootParser);
    }

    public T parse(InputSource source, ParseContext context, NodeParser rootParser) throws IOException, SAXException {
        if (this._rootClass == null && rootParser == null) {
            throw new NullPointerException("Both rootClass and rootParser are null");
        }
        ParseContextWrapper wrappedContext = new ParseContextWrapper(context, this._manager);
        Handler handler = new Handler(wrappedContext, rootParser);
        XMLReader reader = this.getXMLReader();
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        if (this.getEntityResolver() != null) {
            reader.setEntityResolver(this.getEntityResolver());
        }
        reader.parse(source);
        return (T)handler.getRoot();
    }

    protected XMLReader getXMLReader() throws SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException pce) {
            _LOG.log(Level.SEVERE, null, pce);
            return null;
        }
    }

    private class Handler
    implements ContentHandler,
    ErrorHandler {
        private ParseContextWrapper _context;
        private Stack<NodeParser> _parsers;
        private NodeParser _current;
        private Object _root;
        private boolean _fatalError;
        private final NodeParser _rootParser;

        public Handler(ParseContextWrapper context, NodeParser rootParser) {
            this._context = context;
            this._parsers = new Stack();
            this._rootParser = rootParser;
        }

        public Object getRoot() {
            if (!this._parsers.isEmpty()) {
                throw new IllegalStateException();
            }
            return this._root;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            this._context.__addPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        @Override
        public void startDocument() {
            this._parsers.setSize(0);
            this._root = null;
        }

        @Override
        public void endDocument() {
            assert (this._parsers.isEmpty());
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            this._context.__startElement();
            NodeParser parser = this._getCurrentParser();
            if (parser == null) {
                parser = this._rootParser != null ? this._rootParser : this._context.getParser(TreeBuilder.this._rootClass, namespaceURI, localName);
                if (parser == null) {
                    String message = "No " + TreeBuilder.this._rootClass.getName() + " parser registered for top element;check your namespace declaration.   Namespace: " + namespaceURI + "\n   Local name: " + localName + ")";
                    SAXParseException e = new SAXParseException(message, this._context.getLocator());
                    this.fatalError(e);
                    throw e;
                }
                this._pushParser(parser);
            } else {
                NodeParser newParser;
                try {
                    newParser = parser.startChildElement(this._context, namespaceURI, localName, atts);
                }
                catch (SAXParseException e) {
                    this.fatalError(e);
                    throw e;
                }
                if (newParser == parser) {
                    this._pushParser(null);
                    return;
                }
                if (newParser == null) {
                    ParseErrorUtils.log(this._context, "<" + localName + "> is not an understood element.\nThis sometimes means the element's namespace (" + namespaceURI + ") is set incorrectly.  This may also be an issue with the syntax of its parent element.", null, Level.WARNING, _LOG);
                    newParser = BaseNodeParser.getIgnoreParser();
                }
                this._pushParser(newParser);
                parser = newParser;
            }
            try {
                parser.startElement(this._context, namespaceURI, localName, atts);
            }
            catch (SAXParseException e) {
                this.fatalError(e);
                throw e;
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
            NodeParser oldParser = this._popParser();
            NodeParser parser = this._getCurrentParser();
            if (oldParser != null) {
                Object child;
                try {
                    child = oldParser.endElement(this._context, namespaceURI, localName);
                }
                catch (SAXParseException e) {
                    this.fatalError(e);
                    throw e;
                }
                if (parser == null) {
                    assert (this._parsers.isEmpty());
                    this._root = child;
                } else {
                    try {
                        parser.addCompletedChild(this._context, namespaceURI, localName, child);
                    }
                    catch (SAXParseException e) {
                        this.fatalError(e);
                        throw e;
                    }
                }
            }
            if (parser != null && oldParser == null) {
                try {
                    parser.endChildElement(this._context, namespaceURI, localName);
                }
                catch (SAXParseException e) {
                    this.fatalError(e);
                    throw e;
                }
            }
            this._context.__endElement();
        }

        @Override
        public void characters(char[] text, int start, int length) throws SAXException {
            try {
                NodeParser parser = this._getCurrentParser();
                if (parser != null) {
                    parser.addText(this._context, text, start, length);
                }
            }
            catch (SAXParseException e) {
                this.fatalError(e);
                throw e;
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this._context.__setLocator(locator);
        }

        @Override
        public void ignorableWhitespace(char[] text, int start, int length) throws SAXException {
            try {
                NodeParser parser = this._getCurrentParser();
                if (parser != null) {
                    parser.addWhitespace(this._context, text, start, length);
                }
            }
            catch (SAXParseException e) {
                this.fatalError(e);
                throw e;
            }
        }

        @Override
        public void processingInstruction(String target, String data) {
        }

        @Override
        public void skippedEntity(String name) {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this._logError(exception, Level.INFO);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this._logError(exception, Level.WARNING);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            if (!this._fatalError) {
                this._fatalError = true;
                this._logError(exception, Level.SEVERE);
            }
        }

        private void _logError(SAXParseException exception, Level verbosity) {
            ParseErrorUtils.log(this._context, null, exception, exception.getLineNumber(), exception.getColumnNumber(), exception.getSystemId(), verbosity, _LOG);
        }

        private void _pushParser(NodeParser parser) {
            if (parser == null) {
                this._parsers.push(null);
            } else {
                this._parsers.push(parser);
                this._current = parser;
            }
            assert (this._current == this._getLastNonNullParser());
        }

        private NodeParser _popParser() {
            NodeParser entry = this._parsers.pop();
            if (entry != null) {
                this._current = this._getLastNonNullParser();
                return entry;
            }
            return null;
        }

        private NodeParser _getCurrentParser() {
            assert (this._current == this._getLastNonNullParser());
            return this._current;
        }

        private NodeParser _getLastNonNullStackEntry() {
            for (int i = this._parsers.size() - 1; i >= 0; --i) {
                NodeParser entry = (NodeParser)this._parsers.elementAt(i);
                if (entry == null) continue;
                return entry;
            }
            return null;
        }

        private NodeParser _getLastNonNullParser() {
            NodeParser entry = this._getLastNonNullStackEntry();
            if (entry != null) {
                return entry;
            }
            return null;
        }
    }
}

