/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.xml;

import com.scythebill.xml.NamespaceMap;
import com.scythebill.xml.NodeParser;
import com.scythebill.xml.ParseContext;
import com.scythebill.xml.ParserFactory;

public class ParserManager
implements Cloneable {
    private NamespaceMap _factories = new NamespaceMap();
    private boolean _sharedState = false;
    private static final ParserManager _sDefaultInstance = new ParserManager();

    public static ParserManager getDefaultParserManager() {
        return _sDefaultInstance;
    }

    public final NodeParser getParser(ParseContext context, Class<?> expectedType, String namespaceURI, String localName) {
        ParserFactory factory = this.getFactory(expectedType, namespaceURI);
        if (factory == null) {
            return null;
        }
        return factory.getParser(context, namespaceURI, localName);
    }

    public ParserFactory getFactory(Class<?> expectedType, String namespaceURI) {
        return (ParserFactory)this._factories.get(namespaceURI, expectedType);
    }

    public synchronized void registerFactory(Class<?> expectedType, String namespaceURI, ParserFactory factory) {
        this._unshareState();
        this._factories.put(namespaceURI, expectedType, factory);
    }

    public synchronized void unregisterFactory(Class<?> expectedType, String namespaceURI) {
        this._unshareState();
        this._factories.remove(namespaceURI, expectedType);
    }

    public synchronized Object clone() {
        try {
            this._sharedState = true;
            ParserManager pm = (ParserManager)super.clone();
            return pm;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    private synchronized void _unshareState() {
        if (this._sharedState) {
            this._factories = (NamespaceMap)this._factories.clone();
            this._sharedState = false;
        }
    }
}

