/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.xml;

import com.scythebill.xml.ParseContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Locator;

public class ParseErrorUtils {
    public static void log(ParseContext context, String message, Exception e, Level verbosity, Logger log) {
        log.log(verbosity, ParseErrorUtils.getErrorMessage(context, message), e);
    }

    public static void log(ParseContext context, String message, Exception e, int line, int column, String systemId, Level verbosity, Logger log) {
        log.log(verbosity, ParseErrorUtils._getErrorMessage(message, line, column, systemId), e);
    }

    public static String getErrorMessage(ParseContext context, String message) {
        String systemId;
        int column;
        int line;
        Locator locator = context.getLocator();
        if (locator == null) {
            line = -1;
            column = -1;
            systemId = null;
        } else {
            line = locator.getLineNumber();
            column = locator.getColumnNumber();
            systemId = locator.getSystemId();
        }
        return ParseErrorUtils._getErrorMessage(message, line, column, systemId);
    }

    private static String _getErrorMessage(String message, int line, int column, String systemId) {
        Object parseMessage = null;
        if (systemId != null) {
            parseMessage = systemId + ": ";
        }
        Object append = line < 0 || column < 0 ? "Parsing error: " : "Parsing error, line " + line + ", column " + column + ": ";
        parseMessage = parseMessage == null ? append : (String)parseMessage + (String)append;
        if (message != null) {
            parseMessage = (String)parseMessage + message;
        }
        return parseMessage;
    }
}

