/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NamespaceMap
implements Cloneable {
    private Map<String, Map<Object, Object>> _namespaces = new HashMap<String, Map<Object, Object>>();
    private int _defaultSize;

    public NamespaceMap() {
        this(16);
    }

    public NamespaceMap(int defaultSize) {
        this._defaultSize = defaultSize;
    }

    public void put(String namespace, Object key, Object value) {
        this._put(namespace, key, value);
    }

    public Object get(String namespace, Object key) {
        Map<Object, Object> map = this._namespaces.get(namespace);
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public Object remove(String namespace, Object key) {
        Map<Object, Object> map = this._namespaces.get(namespace);
        if (map != null) {
            Object o = map.remove(key);
            if (map.isEmpty()) {
                this._namespaces.remove(namespace);
            }
            return o;
        }
        return null;
    }

    public void remove(String namespace) {
        this._namespaces.remove(namespace);
    }

    public void clear() {
        this._namespaces = new HashMap<String, Map<Object, Object>>();
    }

    public Iterator<String> namespaces() {
        return this._namespaces.keySet().iterator();
    }

    public Object clone() {
        NamespaceMap namespaceMap;
        try {
            namespaceMap = (NamespaceMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
        if (this._namespaces != null) {
            HashMap<String, Map<Object, Object>> newMap = new HashMap<String, Map<Object, Object>>(this._namespaces.size());
            for (Map.Entry<String, Map<Object, Object>> entry : this._namespaces.entrySet()) {
                newMap.put(entry.getKey(), new HashMap<Object, Object>(entry.getValue()));
            }
            namespaceMap._namespaces = newMap;
        }
        return namespaceMap;
    }

    private Object _put(String namespace, Object key, Object value) {
        if (value == null) {
            return this.remove(namespace, key);
        }
        Map<Object, Object> map = this._namespaces.get(namespace);
        if (map == null) {
            map = new HashMap<Object, Object>(this._defaultSize);
            this._namespaces.put(namespace, map);
        }
        return map.put(key, value);
    }
}

