/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.xml;

import com.scythebill.xml.NodeParser;
import com.scythebill.xml.ParseContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class BaseNodeParser
implements NodeParser {
    private static final NodeParser _sInstance = new BaseNodeParser();
    private static final Logger _LOG = Logger.getLogger(BaseNodeParser.class.getName());

    public static NodeParser getIgnoreParser() {
        return _sInstance;
    }

    @Override
    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
    }

    @Override
    public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
        return null;
    }

    @Override
    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        return this;
    }

    @Override
    public void endChildElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
    }

    @Override
    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
    }

    @Override
    public void addText(ParseContext context, char[] text, int start, int length) throws SAXParseException {
    }

    protected final String getRequiredAttribute(ParseContext context, Attributes attrs, String qName) {
        String value = attrs.getValue(qName);
        if (value == null) {
            this.logWarning(context, "Required attribute \"" + qName + "\" not found.");
        }
        return value;
    }

    @Override
    public void addWhitespace(ParseContext context, char[] text, int start, int length) throws SAXParseException {
    }

    protected void logError(ParseContext context, String message, Exception e) throws SAXParseException {
        throw new SAXParseException(message, context.getLocator(), e);
    }

    protected void logUnexpectedElement(ParseContext context, String namespaceURI, String localName) {
        this.logWarning(context, "Local name " + localName + " is not understood");
    }

    protected void logUnexpectedAttribute(ParseContext context, String qName) {
        this.logWarning(context, "\"" + qName + "\" is not an understood attribute");
    }

    protected void logWarning(ParseContext context, String warning) {
        if (_LOG.isLoggable(Level.WARNING)) {
            String location = " [line=" + context.getLocator().getLineNumber() + ", col=" + context.getLocator().getColumnNumber() + "]";
            _LOG.warning(warning + location);
        }
    }
}

