/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.inject.Inject;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

@Singleton
public class VisibilityDetector {
    private static final Logger logger = Logger.getLogger(VisibilityDetector.class.getName());
    private static final int FUDGE_FACTOR = 3;
    private final Alerts alerts;
    private final Timer timer;
    private Component componentToCheck;
    private boolean alertedYet;

    @Inject
    public VisibilityDetector(Alerts alerts) {
        this.alerts = alerts;
        this.timer = new Timer(2000, e -> this.checkIfComponentIsVisible());
        this.timer.setRepeats(false);
    }

    public void install(Component component) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screenDevices = graphicsEnvironment.getScreenDevices();
        if (screenDevices.length > 1) {
            return;
        }
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                VisibilityDetector.this.componentToCheck = e.getComponent();
                VisibilityDetector.this.timer.restart();
            }
        });
    }

    private void checkIfComponentIsVisible() {
        if (this.componentToCheck == null) {
            return;
        }
        if (!this.componentToCheck.isDisplayable()) {
            this.componentToCheck = null;
            return;
        }
        Window window = SwingUtilities.windowForComponent(this.componentToCheck);
        if (window == null) {
            logger.warning("No window for " + this.componentToCheck.getClass());
            return;
        }
        Point bottomRightInWindow = SwingUtilities.convertPoint(this.componentToCheck, this.componentToCheck.getWidth(), this.componentToCheck.getHeight(), SwingUtilities.getRoot(this.componentToCheck));
        Rectangle screenBounds = UIUtils.getScreenBounds(window);
        if (!(screenBounds.x + screenBounds.width + 3 >= bottomRightInWindow.x && screenBounds.y + screenBounds.height + 3 >= bottomRightInWindow.y || this.alertedYet)) {
            this.alertedYet = true;
            this.alerts.showMessage((Object)window, Messages.Name.SCYTHEBILL_DOESNT_FIT_TITLE, Messages.Name.SCYTHEBILL_DOESNT_FIT_MESSAGE, new Object[0]);
        }
    }
}

