/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.primitives.Ints;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.DefaultEditorKit;

public class UIUtils {
    private UIUtils() {
    }

    public static void focusOnEntry(JComponent container, final Component toFocus) {
        container.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent e) {
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorAdded(AncestorEvent e) {
                SwingUtilities.invokeLater(() -> toFocus.requestFocusInWindow());
            }
        });
    }

    public static Action getCopyAction() {
        DefaultEditorKit.CopyAction copy = new DefaultEditorKit.CopyAction();
        copy.putValue("Name", Messages.getMessage(Messages.Name.COPY_MENU));
        copy.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        return copy;
    }

    public static Action getCutAction() {
        DefaultEditorKit.CutAction cut = new DefaultEditorKit.CutAction();
        cut.putValue("Name", Messages.getMessage(Messages.Name.CUT_MENU));
        cut.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        return cut;
    }

    public static Action getPasteAction() {
        DefaultEditorKit.PasteAction paste = new DefaultEditorKit.PasteAction();
        paste.putValue("Name", Messages.getMessage(Messages.Name.PASTE_MENU));
        paste.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        return paste;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public static boolean isMacOSYosemite() {
        Integer pointVersion = UIUtils.getMacOsPointVersion();
        return pointVersion != null && pointVersion == 10;
    }

    private static Integer getMacOsPointVersion() {
        if (!UIUtils.isMacOS()) {
            return null;
        }
        String version = System.getProperty("os.version");
        Pattern pattern = Pattern.compile("10\\.([0-9]*)\\..*");
        Matcher matcher = pattern.matcher(version);
        if (matcher.matches()) {
            String subversion = matcher.group(1);
            return Ints.tryParse(subversion);
        }
        return null;
    }

    public static void fixTabOnTextArea(JTextArea textArea) {
        textArea.setFocusTraversalKeys(0, null);
        textArea.setFocusTraversalKeys(1, null);
    }

    public static void requestFirstFocusInComponent(Container c) {
        Component firstComponent;
        FocusTraversalPolicy policy = UIUtils.getFocusTraversalPolicy(c);
        if (policy != null && (firstComponent = policy.getFirstComponent(c)) != null) {
            firstComponent.requestFocusInWindow();
        }
    }

    public static FocusTraversalPolicy getFocusTraversalPolicy(Container c) {
        while (c != null) {
            FocusTraversalPolicy focusTraversalPolicy = c.getFocusTraversalPolicy();
            if (focusTraversalPolicy != null) {
                return focusTraversalPolicy;
            }
            c = c.getParent();
        }
        return null;
    }

    public static void keepWindowOnScreen(Window window) {
        Rectangle bounds = window.getBounds();
        Rectangle originalBounds = new Rectangle(bounds);
        Rectangle screenBounds = window.getGraphicsConfiguration().getBounds();
        Insets insets = window.getToolkit().getScreenInsets(window.getGraphicsConfiguration());
        bounds.width = Math.min(bounds.width, screenBounds.width - insets.left - insets.right);
        bounds.height = Math.min(bounds.height, screenBounds.height - insets.top - insets.bottom);
        int minX = screenBounds.x + insets.left;
        int minY = screenBounds.y + insets.top;
        bounds.x = Math.max(minX, bounds.x);
        bounds.y = Math.max(minY, bounds.y);
        int maxX = screenBounds.x + screenBounds.width - insets.right;
        int maxY = screenBounds.y + screenBounds.height - insets.bottom;
        bounds.x = Math.min(bounds.x, maxX - bounds.width);
        bounds.y = Math.min(bounds.y, maxY - bounds.height);
        if (originalBounds.equals(bounds)) {
            return;
        }
        if (originalBounds.x == bounds.x && originalBounds.y == bounds.y) {
            window.setSize(bounds.width, bounds.height);
        } else {
            window.setBounds(bounds);
        }
    }

    public static void maximizeWindow(Window window) {
        window.setBounds(UIUtils.getScreenBounds(window));
    }

    public static Rectangle getScreenBounds(Window window) {
        Rectangle screenBounds = window.getGraphicsConfiguration().getBounds();
        Insets insets = window.getToolkit().getScreenInsets(window.getGraphicsConfiguration());
        Rectangle bounds = new Rectangle();
        bounds.x = screenBounds.x + insets.left;
        bounds.y = screenBounds.y + insets.top;
        bounds.width = screenBounds.width - (insets.left + insets.right);
        bounds.height = screenBounds.height - (insets.top + insets.bottom);
        return bounds;
    }

    public static int getFontHeight(Graphics graphics, Font font) {
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        return fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
    }

    public static Frame findFrame(Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                return (Frame)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static <T extends Component> T findParentOfType(Component component, Class<T> type) {
        while ((component = component.getParent()) != null) {
            if (!type.isInstance(component)) continue;
            return (T)((Component)type.cast(component));
        }
        return null;
    }

    public static boolean containsFocus(Component component) {
        Window w = SwingUtilities.getWindowAncestor(component);
        if (w == null) {
            return false;
        }
        Component focusOwner = w.getFocusOwner();
        if (focusOwner == null) {
            return false;
        }
        return SwingUtilities.isDescendingFrom(focusOwner, component);
    }

    public static <T extends Component> T findChildOfType(Container container, Class<T> type) {
        for (Component child : container.getComponents()) {
            Container c;
            T found;
            if (type.isInstance(child)) {
                return (T)((Component)type.cast(child));
            }
            if (!(child instanceof Container) || (found = UIUtils.findChildOfType(c = (Container)child, type)) == null) continue;
            return found;
        }
        return null;
    }
}

