/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.TaxonVisitor;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.util.BaseTreeModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TaxonTreeModel
extends BaseTreeModel
implements TreeModel {
    private final Taxonomy taxonomy;
    private final Map<Taxon.Type, Taxon.Type> nextType;
    private final LoadingCache<Taxon, List<? extends Object>> childrenCache;
    private ReportSet reportSet;
    private Taxon currentSightingsAreFor;
    private Multimap<String, Sighting> currentSightings;
    private Taxon.Type smallestType;
    private Predicate<Sighting> sightingPredicate = Predicates.alwaysTrue();
    private Predicate<Taxon> includedTaxa;

    public TaxonTreeModel(Taxonomy taxonomy, List<Taxon.Type> types, Predicate<Taxon> includedTaxa) {
        this.includedTaxa = includedTaxa == null ? Predicates.alwaysTrue() : includedTaxa;
        Preconditions.checkArgument(ImmutableList.copyOf(Sets.newTreeSet(types)).equals(types));
        this.taxonomy = taxonomy;
        this.nextType = TaxonTreeModel.computeNextTypeMap(types);
        this.smallestType = types.get(0);
        this.childrenCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<Taxon, List<? extends Object>>(){

            @Override
            public List<? extends Object> load(Taxon key) throws Exception {
                return TaxonTreeModel.this.getTaxonChildren(key);
            }
        });
    }

    public void setReportSet(ReportSet reportSet) {
        this.reportSet = reportSet;
        this.currentSightingsAreFor = null;
        this.childrenCache.invalidateAll();
    }

    public void setSightingPredicate(Predicate<Sighting> sightingPredicate) {
        this.sightingPredicate = Preconditions.checkNotNull(sightingPredicate);
        this.currentSightingsAreFor = null;
        this.childrenCache.invalidateAll();
    }

    @Override
    public Object getChild(Object node, int index) {
        return this.getChildNodes(node).get(index);
    }

    @Override
    public int getChildCount(Object node) {
        return this.getChildNodes(node).size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.getChildNodes(parent).indexOf(child);
    }

    @Override
    public Object getRoot() {
        return this.taxonomy.getRoot();
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof Sighting || node == Node.SEPARATOR) {
            return true;
        }
        return this.getChildCount(node) == 0;
    }

    public void sightingsAdded(TreePath parent, List<Sighting> sightings) {
        if (this.currentSightings != null) {
            for (Object o : parent.getPath()) {
                Taxon taxon = (Taxon)o;
                this.childrenCache.invalidate(taxon);
                this.currentSightings.putAll(taxon.getId(), sightings);
            }
        }
        int[] indices = new int[sightings.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.getIndexOfChild(parent.getLastPathComponent(), sightings.get(i));
        }
        Arrays.sort(indices);
        Object[] values = sightings.toArray();
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, parent, indices, values));
    }

    public void sightingsRemoved(TreePath parentPath, List<Sighting> sightings, List<Integer> originalIndices) {
        boolean fullyInvalid = false;
        if (this.currentSightings != null) {
            for (Object o : parentPath.getPath()) {
                Taxon taxon = (Taxon)o;
                this.childrenCache.invalidate(taxon);
                for (Sighting sighting : sightings) {
                    this.currentSightings.remove(taxon.getId(), sighting);
                }
            }
            for (Sighting sighting : sightings) {
                SightingTaxon sightingTaxon = sighting.getTaxon().resolve(this.taxonomy).getSightingTaxon();
                if (sightingTaxon.getType() == SightingTaxon.Type.SINGLE || sightingTaxon.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) continue;
                for (String id : sightingTaxon.getIds()) {
                    for (Taxon taxon = this.taxonomy.getTaxon(id); taxon != null; taxon = taxon.getParent()) {
                        fullyInvalid = true;
                        this.childrenCache.invalidate(taxon);
                        this.currentSightings.remove(taxon.getId(), sighting);
                    }
                }
            }
        }
        int[] indices = new int[originalIndices.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = originalIndices.get(i);
        }
        Arrays.sort(indices);
        if (fullyInvalid) {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, parentPath.getParentPath()));
        } else {
            Object[] values = sightings.toArray();
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, parentPath, indices, values));
        }
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        TreePath parent = path.getParentPath();
        int indexOf = this.getIndexOfChild(parent.getLastPathComponent(), path.getLastPathComponent());
        this.childrenCache.invalidate(parent.getLastPathComponent());
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, parent, new int[]{indexOf}, new Object[]{newValue}));
    }

    private List<? extends Object> getChildNodes(Object node) {
        if (node instanceof Taxon) {
            Taxon taxon = (Taxon)node;
            if (this.nextType.get((Object)taxon.getType()) == null) {
                return this.getSightingsOf(taxon);
            }
            return this.childrenCache.getUnchecked(taxon);
        }
        if (node instanceof Sighting) {
            return ImmutableList.of();
        }
        if (node == Node.SEPARATOR) {
            return ImmutableList.of();
        }
        throw new IllegalArgumentException("Unexpected node type " + node);
    }

    private List<? extends Object> getTaxonChildren(Taxon taxon) {
        final Taxon.Type nextLevel = this.nextType.get((Object)taxon.getType());
        if (nextLevel == null) {
            return this.getSightingsOf(taxon);
        }
        final ImmutableList.Builder children = ImmutableList.builder();
        boolean[] needSeparator = new boolean[]{false};
        if (taxon.getType().compareTo(Taxon.Type.species) <= 0) {
            for (Sighting sighting : this.getSightingsOf(taxon)) {
                SightingTaxon.Resolved resolved = sighting.getTaxon().resolve(this.taxonomy);
                if (resolved.getSmallestTaxonType().compareTo(this.smallestType) < 0) {
                    resolved = resolved.getParentOfAtLeastType(this.smallestType).resolveInternal(this.taxonomy);
                }
                if (!resolved.getSightingTaxon().shouldBeDisplayedWith(taxon.getId())) continue;
                children.add(sighting);
                needSeparator[0] = true;
            }
        }
        TaxonUtils.visitTaxa(taxon, new TaxonVisitor(){

            @Override
            public boolean visitTaxon(Taxon taxon) {
                if (taxon.getType().compareTo(nextLevel) <= 0 && taxon.getType().compareTo(TaxonTreeModel.this.smallestType) >= 0) {
                    if (TaxonTreeModel.this.includedTaxa.apply(taxon)) {
                        children.add(taxon);
                    }
                    return false;
                }
                return true;
            }
        });
        return children.build();
    }

    public List<Sighting> getSightingsOf(Taxon taxon) {
        if (this.reportSet == null) {
            return ImmutableList.of();
        }
        Taxon familyParent = this.getFamilyParent(taxon);
        if (this.currentSightingsAreFor != familyParent) {
            this.currentSightings = ArrayListMultimap.create();
            this.currentSightingsAreFor = familyParent;
            for (Sighting sighting : this.reportSet.getSightings(this.taxonomy)) {
                Object sightingTaxon;
                SightingTaxon.Resolved resolved;
                if (!this.sightingPredicate.apply(sighting) || (resolved = sighting.getTaxon().resolve(this.taxonomy)) == null || !resolved.isChildOf(familyParent)) continue;
                if (resolved.getType() == SightingTaxon.Type.SINGLE) {
                    for (sightingTaxon = resolved.getTaxon(); sightingTaxon != familyParent; sightingTaxon = sightingTaxon.getParent()) {
                        Preconditions.checkState(sightingTaxon != null, "Somehow skipped over parent in " + sighting);
                        if (sightingTaxon.getType() == Taxon.Type.genus) continue;
                        this.currentSightings.put(sightingTaxon.getId(), sighting);
                    }
                    continue;
                }
                sightingTaxon = resolved.getSightingTaxon();
                while (resolved.getSmallestTaxonType().compareTo(Taxon.Type.genus) < 0) {
                    for (String id : sightingTaxon.getIds()) {
                        this.currentSightings.put(id, sighting);
                    }
                    sightingTaxon = resolved.getParent();
                    resolved = sightingTaxon.resolveInternal(this.taxonomy);
                }
            }
        }
        List sightingList = (List)this.currentSightings.get(taxon.getId());
        Collections.sort(sightingList, SightingComparators.preferEarlier());
        return sightingList;
    }

    private Taxon getFamilyParent(Taxon taxon) {
        return TaxonUtils.getParentOfType(taxon, Taxon.Type.family);
    }

    private static Map<Taxon.Type, Taxon.Type> computeNextTypeMap(List<Taxon.Type> displayedTypes) {
        ImmutableMap.Builder<Taxon.Type, Taxon.Type> builder = ImmutableMap.builder();
        ArrayList<Taxon.Type> typesFromLargestToSmallest = Lists.newArrayList(Taxon.Type.values());
        Collections.reverse(typesFromLargestToSmallest);
        for (Taxon.Type type : typesFromLargestToSmallest) {
            Taxon.Type nextType = null;
            for (Taxon.Type displayedType : displayedTypes) {
                if (displayedType.compareTo(type) >= 0) break;
                nextType = displayedType;
            }
            if (nextType == null) continue;
            builder.put(type, nextType);
        }
        return builder.build();
    }

    public void sightingsReplaced(TreePath parent, List<Sighting> oldSightings, List<Sighting> newSightings, int[] oldIndices) {
        this.currentSightingsAreFor = null;
        this.childrenCache.invalidateAll();
        int[] newIndices = new int[newSightings.size()];
        boolean anyDifferent = false;
        for (int i = 0; i < newIndices.length; ++i) {
            newIndices[i] = this.getIndexOfChild(parent.getLastPathComponent(), newSightings.get(i));
            if (newIndices[i] == oldIndices[i]) continue;
            anyDifferent = true;
        }
        if (anyDifferent) {
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, parent, oldIndices, oldSightings.toArray()));
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, parent, newIndices, newSightings.toArray()));
        } else {
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, parent, newIndices, newSightings.toArray()));
        }
    }

    public void sightingsRemoved(TreePath parent, List<Sighting> oldSightings, int[] indices) {
        this.currentSightingsAreFor = null;
        this.childrenCache.invalidateAll();
        this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, parent, indices, oldSightings.toArray()));
    }

    public void structureChanged(TreePath path) {
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, path));
    }

    public static enum Node {
        SEPARATOR;


        public String toString() {
            return "";
        }
    }
}

