/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Provider;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.util.ReportSetScanner;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class TaxonScorer {
    private static final Logger logger = Logger.getLogger(TaxonScorer.class.getName());
    private final LoadingCache<String, ScoreAccumulator> accumulators;
    private final Taxonomy taxonomy;
    private final ImmutableList<ReportSet> reportSets;

    public TaxonScorer(Taxonomy taxonomy, Iterable<ReportSet> reportSets, Provider<ScoreAccumulator> accumulatorFactory) {
        this.taxonomy = taxonomy;
        this.reportSets = ImmutableList.copyOf(reportSets);
        this.accumulators = CacheBuilder.newBuilder().build(CacheLoader.from(accumulatorFactory::get));
    }

    public int getScore(String key) {
        ScoreAccumulator accumulator = (ScoreAccumulator)this.accumulators.getIfPresent(key);
        return accumulator == null ? 0 : accumulator.reportScore();
    }

    public Ordering<String> ordering() {
        return new StableOrdering();
    }

    public Future<?> start(ListeningExecutorService executorService) {
        Future submitted = executorService.submit(() -> {
            for (ReportSet reportSet : this.reportSets) {
                new ScoringRunnable(this.taxonomy, reportSet).call();
            }
            return null;
        });
        Futures.addCallback(submitted, new FutureCallback<Void>(){

            @Override
            public void onSuccess(Void result) {
            }

            @Override
            public void onFailure(Throwable t) {
                logger.log(Level.WARNING, "Scoring failed", t);
            }
        }, executorService);
        return submitted;
    }

    static interface ScoreAccumulator {
        public void accumulate(Sighting var1);

        public int reportScore();
    }

    class StableOrdering
    extends Ordering<String> {
        private final LoadingCache<String, Integer> cache = this.newCache();

        private StableOrdering() {
        }

        @Override
        public <E extends String> List<E> sortedCopy(Iterable<E> iterable) {
            try {
                return super.sortedCopy(iterable);
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, "Failed to sort" + iterable, e);
                return Lists.newArrayList(iterable);
            }
        }

        @Override
        public <E extends String> ImmutableList<E> immutableSortedCopy(Iterable<E> iterable) {
            try {
                return super.immutableSortedCopy(iterable);
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, "Failed to sort" + iterable, e);
                return ImmutableList.copyOf(iterable);
            }
        }

        @Override
        public int compare(String first, String second) {
            return Integer.compare(this.cache.getUnchecked(second), this.cache.getUnchecked(first));
        }

        private LoadingCache<String, Integer> newCache() {
            return CacheBuilder.newBuilder().build(CacheLoader.from(key -> {
                ScoreAccumulator accumulator = (ScoreAccumulator)TaxonScorer.this.accumulators.getIfPresent(key);
                return accumulator == null ? 0 : accumulator.reportScore();
            }));
        }
    }

    private class ScoringRunnable
    extends ReportSetScanner<Void> {
        protected ScoringRunnable(Taxonomy taxonomy, ReportSet reportSet) {
            super(taxonomy, reportSet);
        }

        @Nullable
        private String getSightingKey(Sighting entry, SightingTaxon sightingTaxon) {
            if (sightingTaxon.getType() != SightingTaxon.Type.SINGLE) {
                return null;
            }
            Taxon taxon = TaxonScorer.this.taxonomy.getTaxon(sightingTaxon.getId());
            Taxon species = TaxonUtils.getParentOfType(taxon, Taxon.Type.species);
            return species.getId();
        }

        @Nullable
        private String getSecondarySightingKey(Sighting entry, SightingTaxon sightingTaxon) {
            if (sightingTaxon.getType() != SightingTaxon.Type.SINGLE) {
                return null;
            }
            Taxon taxon = TaxonScorer.this.taxonomy.getTaxon(sightingTaxon.getId());
            if (taxon.getType() == Taxon.Type.species) {
                return null;
            }
            return taxon.getId();
        }

        @Override
        protected void process(Sighting sighting, SightingTaxon taxon) throws Exception {
            String key = this.getSightingKey(sighting, taxon);
            if (key == null) {
                return;
            }
            ScoreAccumulator accumulator = TaxonScorer.this.accumulators.get(key);
            accumulator.accumulate(sighting);
            String secondaryKey = this.getSecondarySightingKey(sighting, taxon);
            if (secondaryKey != null) {
                accumulator = TaxonScorer.this.accumulators.get(secondaryKey);
                accumulator.accumulate(sighting);
            }
        }

        @Override
        protected Void accumulated() {
            return null;
        }
    }
}

