/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.base.CharMatcher;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.util.ToString;
import com.scythebill.birdlist.ui.messages.Messages;

public class SubspeciesToString
implements ToString<Taxon> {
    @Override
    public String getString(Taxon t) {
        if (t == null || t.getType() == Taxon.Type.species) {
            return Messages.getMessage(Messages.Name.SUBSPECIES_UNSPECIFIED);
        }
        if (t.getCommonName() != null) {
            String name = t.getCommonName();
            Taxon species = TaxonUtils.getParentOfType(t, Taxon.Type.species);
            if (species.getCommonName() != null && name.startsWith(species.getCommonName())) {
                name = CharMatcher.whitespace().trimFrom(name.substring(species.getCommonName().length()));
            }
            if (name.equals(t.getName())) {
                return name;
            }
            return t.getName() + " " + name;
        }
        String groupIndent = t.getType() == Taxon.Type.subspecies && t.getParent().getType() == Taxon.Type.group ? "    " : "";
        Taxon genus = TaxonUtils.getParentOfType(t, Taxon.Type.genus);
        Taxon species = TaxonUtils.getParentOfType(t, Taxon.Type.species);
        return groupIndent + genus.getName().charAt(0) + "." + species.getName().charAt(0) + "." + t.getName();
    }

    @Override
    public String getPreviewString(Taxon t) {
        return this.getString(t);
    }
}

