/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.ui.messages.Messages;

public final class SightingFlags {
    private SightingFlags() {
    }

    public static String appendSightingInfo(String text, Sighting sighting) {
        switch (sighting.getSightingInfo().getSightingStatus()) {
            case INTRODUCED: 
            case RECORD_NOT_ACCEPTED: 
            case INTRODUCED_NOT_ESTABLISHED: 
            case NOT_BY_ME: 
            case SIGNS: 
            case DOMESTIC: 
            case RESTRAINED: 
            case UNSATISFACTORY_VIEWS: {
                text = (String)text + " - " + Messages.getText(sighting.getSightingInfo().getSightingStatus()).toLowerCase();
                break;
            }
            case DEAD: {
                text = (String)text + " (\u2020)";
                break;
            }
            case ID_UNCERTAIN: {
                text = (String)text + " (?)";
                break;
            }
            case BETTER_VIEW_DESIRED: {
                text = (String)text + " (BVD)";
            }
        }
        if (sighting.getSightingInfo().isHeardOnly()) {
            text = (String)text + " (H)";
        }
        return text;
    }

    public static String getAbbreviatedSightingFlags(SightingInfo sightingInfo) {
        Object text = null;
        switch (sightingInfo.getSightingStatus()) {
            case INTRODUCED: {
                text = Messages.getMessage(Messages.Name.SIGHTING_STATUS_INTRODUCED_ABBREVIATION);
                break;
            }
            case INTRODUCED_NOT_ESTABLISHED: {
                text = Messages.getMessage(Messages.Name.SIGHTING_STATUS_INTRODUCED_NOT_ESTABLISHED_ABBREVIATION);
                break;
            }
            case RECORD_NOT_ACCEPTED: {
                text = Messages.getMessage(Messages.Name.SIGHTING_STATUS_RECORD_NOT_ACCEPTED_ABBREVIATION);
                break;
            }
            case BETTER_VIEW_DESIRED: {
                text = Messages.getMessage(Messages.Name.SIGHTING_STATUS_BETTER_VIEW_DESIRED_ABBREVIATION);
                break;
            }
            case UNSATISFACTORY_VIEWS: {
                text = Messages.getMessage(Messages.Name.SIGHTING_STATUS_UNSATISFACTORY_VIEWS_ABBREVIATION);
                break;
            }
            case NOT_BY_ME: 
            case SIGNS: 
            case DOMESTIC: 
            case RESTRAINED: {
                text = Messages.getText(sightingInfo.getSightingStatus());
                break;
            }
            case DEAD: {
                text = "(\u2020)";
                break;
            }
            case ID_UNCERTAIN: {
                text = "(?)";
                break;
            }
            case NONE: {
                text = null;
            }
        }
        if (sightingInfo.isHeardOnly()) {
            text = text == null ? "(H)" : (String)text + " (H)";
        }
        return text;
    }
}

