/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.util.ResolvedComparator;
import java.util.Comparator;
import java.util.Objects;
import org.joda.time.ReadablePartial;

public class ResolvedWithKey
implements Comparable<ResolvedWithKey> {
    private static final Comparator<ResolvedWithKey> COMPARATOR = Comparator.comparing(ResolvedWithKey::getResolved, new ResolvedComparator()).thenComparing(rwk -> rwk.getDate(), SightingComparators::comparePartials);
    private final SightingTaxon.Resolved resolved;
    private final VisitInfoKey visitInfoKey;
    private final Trip trip;

    public ResolvedWithKey(SightingTaxon.Resolved resolved, VisitInfoKey visitInfoKey) {
        this.resolved = resolved;
        this.visitInfoKey = visitInfoKey;
        this.trip = null;
    }

    public ResolvedWithKey(SightingTaxon.Resolved resolved, Trip trip) {
        this.resolved = resolved;
        this.visitInfoKey = null;
        this.trip = trip;
    }

    public SightingTaxon.Resolved getResolved() {
        return this.resolved;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolvedWithKey)) {
            return false;
        }
        ResolvedWithKey that = (ResolvedWithKey)o;
        return this.resolved.equals(that.resolved) && Objects.equals(this.getVisitInfoKey(), that.getVisitInfoKey()) && this.getTrip() == that.getTrip();
    }

    public int hashCode() {
        return Objects.hash(this.resolved, this.getVisitInfoKey(), this.getTrip());
    }

    @Override
    public int compareTo(ResolvedWithKey o) {
        return COMPARATOR.compare(this, o);
    }

    private ReadablePartial getDate() {
        if (this.getVisitInfoKey() != null) {
            return this.getVisitInfoKey().date();
        }
        return this.getTrip().startDate();
    }

    public VisitInfoKey getVisitInfoKey() {
        return this.visitInfoKey;
    }

    public Trip getTrip() {
        return this.trip;
    }
}

