/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.collect.ImmutableList;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;

public abstract class ReportSetScanner<T>
implements Callable<T> {
    private static final int BLOCK_SIZE = 1000;
    private final List<Sighting> list;
    private final ReadWriteLock readWriteLock;
    private final MappedTaxonomy mappedTaxonomy;
    private final Taxonomy taxonomy;
    private final Taxonomy baseTaxonomy;

    protected ReportSetScanner(Taxonomy taxonomy, ReportSet reportSet) {
        this.taxonomy = taxonomy;
        this.baseTaxonomy = TaxonUtils.getBaseTaxonomy(taxonomy);
        this.mappedTaxonomy = taxonomy instanceof MappedTaxonomy ? (MappedTaxonomy)taxonomy : null;
        this.list = reportSet.getSightings();
        this.readWriteLock = reportSet.sightingsLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        try {
            int size;
            this.readWriteLock.readLock().lockInterruptibly();
            try {
                size = this.list.size();
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
            for (int i = size / 1000 * 1000; i >= 0; i -= 1000) {
                ImmutableList<Sighting> sublist;
                this.readWriteLock.readLock().lockInterruptibly();
                try {
                    sublist = ImmutableList.copyOf(this.list.subList(i, Math.min(size, i + 1000)));
                }
                finally {
                    this.readWriteLock.readLock().unlock();
                }
                for (Sighting entry : sublist) {
                    if (entry.getTaxonomy() != this.baseTaxonomy) {
                        this.processIncompatibleSighting(entry, entry.getTaxon());
                        continue;
                    }
                    SightingTaxon taxon = entry.getTaxon();
                    if (this.resolveTaxaToTaxonomy() && this.mappedTaxonomy != null) {
                        taxon = this.mappedTaxonomy.resolveInto(taxon).getSightingTaxon();
                    }
                    this.process(entry, taxon);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.accumulated();
    }

    protected abstract void process(Sighting var1, SightingTaxon var2) throws Exception;

    protected void processIncompatibleSighting(Sighting sighting, SightingTaxon taxon) throws Exception {
    }

    protected abstract T accumulated();

    protected boolean resolveTaxaToTaxonomy() {
        return true;
    }

    protected Taxonomy getTaxonomy() {
        return this.taxonomy;
    }
}

