/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.ui.actions.locationapi.LocationApiPreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import java.net.URI;

public class OpenMapUrl {
    private final LocationApiPreferences locationApiPreferences;
    private final Alerts alerts;

    @Inject
    public OpenMapUrl(LocationApiPreferences locationApiPreferences, Alerts alerts) {
        this.locationApiPreferences = locationApiPreferences;
        this.alerts = alerts;
    }

    public void openLatLong(LatLongCoordinates latLong) {
        String url = this.locationApiPreferences.mapProvider.mapUrl(latLong);
        if (url != null) {
            DesktopUtils.openUrlInBrowser(URI.create(url), this.alerts);
        }
    }
}

