/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;

public class MoreFiles {
    private MoreFiles() {
    }

    public static CommonSuffixResults commonSuffix(File oldDirectory, File newDirectory) {
        ImmutableList.Builder commonSuffix = ImmutableList.builder();
        while (oldDirectory != null && newDirectory != null && oldDirectory.getName().equals(newDirectory.getName())) {
            commonSuffix.add(oldDirectory.getName());
            oldDirectory = oldDirectory.getParentFile();
            newDirectory = newDirectory.getParentFile();
        }
        return new CommonSuffixResults(((ImmutableList)commonSuffix.build()).reverse(), oldDirectory, newDirectory);
    }

    public static boolean isChildOf(File possibleParent, File file) {
        for (file = file.getParentFile(); file != null; file = file.getParentFile()) {
            if (!possibleParent.equals(file)) continue;
            return true;
        }
        return false;
    }

    public record CommonSuffixResults(ImmutableList<String> commonSuffix, File oldDirectory, File newDirectory) {
        public File replacePrefix(File file) {
            ArrayList<String> pathComponents = new ArrayList<String>();
            while (file != null) {
                pathComponents.add(file.getName());
                if (!Objects.equals(file = file.getParentFile(), this.oldDirectory)) continue;
            }
            file = this.newDirectory;
            for (int i = pathComponents.size() - 1; i >= 0; --i) {
                file = file == null ? new File((String)pathComponents.get(i)) : new File(file, (String)pathComponents.get(i));
            }
            return file;
        }
    }
}

