/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.inject.Provider;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.util.TaxonScorer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTimeFieldType;
import org.joda.time.ReadablePartial;

public class LocationTaxonScorer {
    private static String RARITY_MARKER = "#%!(\\|";

    public static TaxonScorer newTaxonScorer(Taxonomy taxonomy, ReportSet reportSet, Location currentLocation, @Nullable ReadablePartial date, Checklists checklists) {
        ReportSet checklistReports = LocationTaxonScorer.createChecklistReports(taxonomy, reportSet, currentLocation, date, checklists);
        return new TaxonScorer(taxonomy, ImmutableList.of(checklistReports, reportSet), new LocationScoreAccumulatorFactory(reportSet.getLocations(), currentLocation, date));
    }

    private static ReportSet createChecklistReports(Taxonomy taxonomy, ReportSet reportSet, Location currentLocation, @Nullable ReadablePartial date, Checklists checklists) {
        ArrayList<Sighting> checklistSightings = Lists.newArrayList();
        for (Location checklistLocation = currentLocation; checklistLocation != null; checklistLocation = checklistLocation.getParent()) {
            Checklist checklist = checklists.getChecklist(reportSet, taxonomy, checklistLocation);
            if (checklist == null) continue;
            LocationTaxonScorer.addSightingsSimulatingChecklist(checklistSightings, checklist, taxonomy, date, checklistLocation);
        }
        ReportSet checklistReports = new ReportSet(reportSet.getLocations(), new Trips(reportSet.getLocations()), checklistSightings, taxonomy);
        return checklistReports;
    }

    private static void addSightingsSimulatingChecklist(List<Sighting> checklistSightings, Checklist checklist, Taxonomy taxonomy, @Nullable ReadablePartial date, Location checklistLocation) {
        if (taxonomy instanceof MappedTaxonomy) {
            MappedTaxonomy mapped = (MappedTaxonomy)taxonomy;
            for (SightingTaxon taxon : checklist.getTaxa(taxonomy)) {
                Checklist.Status status = checklist.getStatus(taxonomy, taxon);
                boolean isRarity = status == Checklist.Status.RARITY || status == Checklist.Status.RARITY_FROM_INTRODUCED;
                SightingTaxon base = mapped.getMapping(taxon);
                if (base.getType() == SightingTaxon.Type.SINGLE || base.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
                    Sighting sighting = Sighting.newBuilder().setTaxonomy(mapped.getBaseTaxonomy()).setLocation(checklistLocation).setTaxon(base).setDate(date).build();
                    if (isRarity) {
                        sighting.getSightingInfo().setDescription(RARITY_MARKER);
                    }
                    checklistSightings.add(sighting);
                    continue;
                }
                for (String id : base.getIds()) {
                    Sighting sighting = Sighting.newBuilder().setLocation(checklistLocation).setTaxonomy(mapped.getBaseTaxonomy()).setDate(date).setTaxon(SightingTaxons.newSightingTaxon(id)).build();
                    if (isRarity) {
                        sighting.getSightingInfo().setDescription(RARITY_MARKER);
                    }
                    checklistSightings.add(sighting);
                }
            }
        } else {
            for (SightingTaxon taxon : checklist.getTaxa(taxonomy)) {
                Checklist.Status status = checklist.getStatus(taxonomy, taxon);
                boolean isRarity = status == Checklist.Status.RARITY || status == Checklist.Status.RARITY_FROM_INTRODUCED;
                Sighting sighting = Sighting.newBuilder().setTaxonomy(taxonomy).setLocation(checklistLocation).setTaxon(taxon).setDate(date).build();
                if (isRarity) {
                    sighting.getSightingInfo().setDescription(RARITY_MARKER);
                }
                checklistSightings.add(sighting);
            }
        }
    }

    private static int getDepth(Location location) {
        int depth = 0;
        while (location != null) {
            location = location.getParent();
            ++depth;
        }
        return depth;
    }

    static class LocationScoreAccumulatorFactory
    implements Provider<TaxonScorer.ScoreAccumulator> {
        private final LocationSet locationSet;
        private final ImmutableMap<String, Integer> bucketMap;
        private final int month;

        public LocationScoreAccumulatorFactory(LocationSet locationSet, Location currentLocation, @Nullable ReadablePartial time) {
            this.locationSet = locationSet;
            int currentDepth = LocationTaxonScorer.getDepth(currentLocation);
            ImmutableMap.Builder<String, Integer> mapBuilder = ImmutableMap.builder();
            while (currentLocation != null) {
                mapBuilder.put(currentLocation.getId(), currentDepth - 1);
                --currentDepth;
                currentLocation = currentLocation.getParent();
            }
            this.bucketMap = mapBuilder.build();
            this.month = time != null && time.isSupported(DateTimeFieldType.monthOfYear()) ? time.get(DateTimeFieldType.monthOfYear()) : -1;
        }

        @Override
        public TaxonScorer.ScoreAccumulator get() {
            return new LocationScoreAccumulator();
        }

        class LocationScoreAccumulator
        implements TaxonScorer.ScoreAccumulator {
            private final int[] buckets;
            private final int[] dateMultiplierBuckets;
            private volatile int score;

            LocationScoreAccumulator() {
                this.buckets = new int[LocationScoreAccumulatorFactory.this.bucketMap.size()];
                this.dateMultiplierBuckets = new int[LocationScoreAccumulatorFactory.this.bucketMap.size()];
                this.score = -1;
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("buckets", Ints.asList(this.buckets)).add("dateBuckets", Ints.asList(this.dateMultiplierBuckets)).add("score", this.reportScore()).toString();
            }

            @Override
            public void accumulate(Sighting sighting) {
                int bucket = this.getLocationBucket(sighting);
                if (bucket >= 0) {
                    boolean isRarity;
                    int sightingMonth;
                    int multiplier;
                    int existingDateMultiplier;
                    ReadablePartial sightingDate;
                    if (LocationScoreAccumulatorFactory.this.month != -1 && (sightingDate = sighting.getStartDateAsPartial()) != null && sightingDate.isSupported(DateTimeFieldType.monthOfYear()) && (existingDateMultiplier = this.dateMultiplierBuckets[bucket]) < (multiplier = 7 - Math.abs((sightingMonth = sightingDate.get(DateTimeFieldType.monthOfYear())) - LocationScoreAccumulatorFactory.this.month))) {
                        this.dateMultiplierBuckets[bucket] = multiplier;
                    }
                    boolean bl = isRarity = sighting.hasSightingInfo() && sighting.getSightingInfo().getDescription() == RARITY_MARKER;
                    if (isRarity) {
                        int n = bucket;
                        this.buckets[n] = this.buckets[n] + 1;
                    } else {
                        int n = bucket;
                        this.buckets[n] = this.buckets[n] + 3;
                    }
                }
                this.score = -1;
            }

            private int getLocationBucket(Sighting sighting) {
                if (sighting.getLocationId() == null) {
                    return -1;
                }
                Integer bucket = LocationScoreAccumulatorFactory.this.bucketMap.get(sighting.getLocationId());
                if (bucket != null) {
                    return bucket;
                }
                for (Location location = LocationScoreAccumulatorFactory.this.locationSet.getLocation(sighting.getLocationId()).getParent(); location != null; location = location.getParent()) {
                    bucket = LocationScoreAccumulatorFactory.this.bucketMap.get(location.getId());
                    if (bucket == null) continue;
                    return bucket;
                }
                return -1;
            }

            @Override
            public int reportScore() {
                if (this.score > 0) {
                    return this.score;
                }
                int total = 0;
                int baseMultiplier = 1;
                for (int i = 0; i < this.buckets.length; ++i) {
                    int bucketCount = this.buckets[i];
                    if (bucketCount > 9) {
                        bucketCount = 9;
                    }
                    int increment = baseMultiplier * bucketCount;
                    int dateMultiplier = this.dateMultiplierBuckets[i] - 3;
                    if (dateMultiplier > 1) {
                        increment *= dateMultiplier * dateMultiplier * dateMultiplier;
                    }
                    total += increment;
                    baseMultiplier *= 10;
                }
                this.score = total;
                return total;
            }
        }
    }
}

