/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.ui.util.ReportSetScanner;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

@Singleton
public class LocationScorer {
    private final ReportSet reportSet;
    private final ListeningExecutorService listeningExecutorService;
    private volatile Scorer scorer;

    @Inject
    public LocationScorer(ReportSet reportSet, ListeningExecutorService listeningExecutorService) {
        this.reportSet = reportSet;
        this.listeningExecutorService = listeningExecutorService;
        this.reportSet.getDirty().addDirtyListener(e -> {
            if (e.getOldValue().equals(Boolean.FALSE) && e.getNewValue().equals(Boolean.TRUE)) {
                this.scorer = null;
            }
        });
    }

    public Supplier<Ordering<Object>> ordering() {
        Scorer localScorer = this.scorer;
        if (this.scorer == null) {
            this.scorer = localScorer = new Scorer(this.reportSet);
            localScorer.start(this.listeningExecutorService);
        }
        Scorer finalScorer = localScorer;
        return () -> finalScorer.ordering();
    }

    public Supplier<Ordering<String>> stringOrdering() {
        final Supplier<Ordering<Object>> supplier = Suppliers.memoize(this.ordering());
        return () -> new Ordering<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return ((Ordering)supplier.get()).compare(arg0, arg1);
            }
        };
    }

    static class Scorer {
        private static final Logger logger = Logger.getLogger(Scorer.class.getName());
        private final LoadingCache<Object, ScoreAccumulator> accumulators;
        private final ReportSet reportSet;
        private final int currentYear;

        public Scorer(ReportSet reportSet) {
            this.reportSet = reportSet;
            this.accumulators = CacheBuilder.newBuilder().build(CacheLoader.from(() -> new ScoreAccumulator()));
            LocalDate now = LocalDate.now();
            this.currentYear = now.get(DateTimeFieldType.year());
        }

        public double getScore(String key) {
            ScoreAccumulator accumulator = (ScoreAccumulator)this.accumulators.getIfPresent(key);
            return accumulator == null ? 0.0 : (double)accumulator.reportScore();
        }

        public Ordering<Object> ordering() {
            return new StableOrdering();
        }

        public Future<?> start(ListeningExecutorService executorService) {
            Future submitted = executorService.submit(() -> (Void)new ScoringRunnable(this.reportSet).call());
            Futures.addCallback(submitted, new FutureCallback<Void>(){

                @Override
                public void onSuccess(Void result) {
                }

                @Override
                public void onFailure(Throwable t) {
                    logger.log(Level.WARNING, "Scoring failed", t);
                }
            }, executorService);
            return submitted;
        }

        class ScoreAccumulator {
            volatile int score = 0;

            ScoreAccumulator() {
            }

            void accumulate(int addedScore) {
                this.score += addedScore;
            }

            int reportScore() {
                return this.score;
            }

            public String toString() {
                return Integer.toString(this.score);
            }
        }

        class StableOrdering
        extends Ordering<Object> {
            private final LoadingCache<Object, Integer> cache = this.newCache();

            private StableOrdering() {
            }

            @Override
            public <E> List<E> sortedCopy(Iterable<E> iterable) {
                try {
                    return super.sortedCopy(iterable);
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, "Failed to sort" + iterable, e);
                    return Lists.newArrayList(iterable);
                }
            }

            @Override
            public <E> ImmutableList<E> immutableSortedCopy(Iterable<E> iterable) {
                try {
                    return super.immutableSortedCopy(iterable);
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, "Failed to sort" + iterable, e);
                    return ImmutableList.copyOf(iterable);
                }
            }

            @Override
            public int compare(Object first, Object second) {
                return Double.compare(second == null ? 0.0 : (double)this.cache.getUnchecked(second).intValue(), first == null ? 0.0 : (double)this.cache.getUnchecked(first).intValue());
            }

            private LoadingCache<Object, Integer> newCache() {
                return CacheBuilder.newBuilder().build(CacheLoader.from(key -> {
                    String ks;
                    ScoreAccumulator accumulator = (ScoreAccumulator)Scorer.this.accumulators.getIfPresent(key);
                    if (accumulator != null) {
                        return accumulator.reportScore();
                    }
                    if (key instanceof String && SyntheticLocation.isSyntheticLocation(ks = (String)key)) {
                        return 500;
                    }
                    return 0;
                }));
            }
        }

        private class ScoringRunnable
        extends ReportSetScanner<Void> {
            private final LocationSet locationSet;
            private Set<VisitInfoKey> visitInfoKeys;
            private Set<Trip> trips;

            protected ScoringRunnable(ReportSet reportSet) {
                super(null, reportSet);
                this.visitInfoKeys = new HashSet<VisitInfoKey>();
                this.trips = new HashSet<Trip>();
                this.locationSet = reportSet.getLocations();
            }

            @Override
            protected void processIncompatibleSighting(Sighting sighting, SightingTaxon taxon) throws Exception {
                this.process(sighting, taxon);
            }

            @Override
            protected void process(Sighting sighting, SightingTaxon taxon) throws Exception {
                String locationId;
                VisitInfoKey visitInfoKey = VisitInfoKey.forSighting(sighting);
                if (visitInfoKey != null) {
                    if (!this.visitInfoKeys.add(visitInfoKey)) {
                        return;
                    }
                    locationId = visitInfoKey.locationId();
                } else if (sighting.getLocationId() != null) {
                    locationId = sighting.getLocationId();
                } else if (sighting.getTrip() != null) {
                    if (!this.trips.add(sighting.getTrip())) {
                        return;
                    }
                    locationId = sighting.getTrip().locationId();
                } else {
                    return;
                }
                if (locationId == null) {
                    return;
                }
                int score = this.getScore(sighting.getEndDateAsPartial());
                Location location = this.locationSet.getLocation(locationId);
                do {
                    ScoreAccumulator accumulator = Scorer.this.accumulators.get(location.getId());
                    accumulator.accumulate(score);
                } while ((location = location.getParent()) != null);
            }

            @Override
            protected boolean resolveTaxaToTaxonomy() {
                return false;
            }

            @Override
            protected Void accumulated() {
                return null;
            }

            private int getScore(ReadablePartial date) {
                if (date == null || !date.isSupported(DateTimeFieldType.year())) {
                    return 0;
                }
                int year = date.get(DateTimeFieldType.year());
                return Math.max(10, Math.min(0, Scorer.this.currentYear - year));
            }
        }
    }
}

