/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMultimap;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.query.SyntheticLocations;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.util.Indexer;
import com.scythebill.birdlist.model.util.ToString;
import com.scythebill.birdlist.ui.messages.Messages;
import java.util.Collection;
import javax.annotation.Nullable;

public class LocationIdToString
implements ToString<String> {
    private boolean verbose;
    private final LocationSet locations;
    private Location verboseRoot;
    private final SyntheticLocations syntheticLocations;
    private String nullName = Messages.getMessage(Messages.Name.WORLD_TEXT);
    public static final ImmutableMultimap<String, String> ALTERNATE_INDEX_ENTRIES;

    public LocationIdToString(LocationSet locations, SyntheticLocations syntheticLocations) {
        this.locations = locations;
        this.syntheticLocations = syntheticLocations;
    }

    public void setVerboseRoot(Location verboseRoot) {
        this.verboseRoot = verboseRoot;
    }

    public void setNullName(String nullName) {
        this.nullName = nullName;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Indexer<String> createIndexer(boolean addNullName) {
        return this.createIndexer(addNullName, Predicates.alwaysTrue());
    }

    public Indexer<String> createIndexer(boolean addNullName, Predicate<Location> locationPredicate) {
        Indexer<String> index = new Indexer<String>();
        index.setAlternateIndexEntries(ALTERNATE_INDEX_ENTRIES);
        for (Location loc : this.locations.rootLocations()) {
            this.addToLocationIndex(index, loc, locationPredicate);
        }
        if (addNullName) {
            index.add(this.nullName, null);
        }
        if (this.syntheticLocations != null) {
            this.registerSyntheticLocations(index, this.syntheticLocations);
        }
        return index;
    }

    @Override
    public String getString(String id) {
        String syntheticName = this.getSyntheticName(id);
        if (syntheticName != null) {
            return syntheticName;
        }
        Location loc = this.locations.getLocation(id);
        return loc.getDisplayName();
    }

    @Override
    public String getPreviewString(String id) {
        String syntheticName = this.getSyntheticName(id);
        if (syntheticName != null) {
            return syntheticName;
        }
        return LocationIdToString.getString(this.locations, id, this.isVerbose(), this.verboseRoot);
    }

    @Nullable
    private String getSyntheticName(String id) {
        SyntheticLocation synthetic;
        if (id == null) {
            return this.nullName;
        }
        if (this.syntheticLocations != null && (synthetic = this.syntheticLocations.byId(id)) != null) {
            return synthetic.getDisplayName();
        }
        return null;
    }

    public static String getString(LocationSet locations, String id) {
        return LocationIdToString.getString(locations, id, false, null);
    }

    public static String getString(LocationSet locations, String id, boolean verbose, Location verboseRoot) {
        if (id == null) {
            return Messages.getMessage(Messages.Name.WORLD_TEXT);
        }
        Location loc = locations.getLocation(id);
        if (loc == verboseRoot) {
            return LocationIdToString.locationNameAtStart(locations, loc, true);
        }
        if (verbose) {
            StringBuilder builder = new StringBuilder();
            while (loc != verboseRoot && loc != null) {
                boolean usefulEbirdCode;
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                boolean isLastEntry = loc.getType() == Location.Type.country;
                boolean bl = usefulEbirdCode = loc.getEbirdCode() != null && !loc.getEbirdCode().contains("-");
                if (builder.length() > 0 && !isLastEntry && usefulEbirdCode) {
                    builder.append(loc.getEbirdCode());
                } else if (builder.length() == 0) {
                    builder.append(LocationIdToString.locationNameAtStart(locations, loc, false));
                } else {
                    builder.append(LocationIdToString.getNameForLocationInFullAncestorList(loc));
                }
                if (isLastEntry) break;
                Location parent = loc.getParent();
                if (parent != null && loc.getDisplayName().equals(parent.getDisplayName())) {
                    parent = parent.getParent();
                }
                loc = parent;
            }
            return builder.toString();
        }
        return LocationIdToString.getNonVerboseString(locations, loc, true);
    }

    private static String locationNameAtStart(LocationSet locations, Location loc, boolean standalone) {
        if (loc.getType() == Location.Type.county) {
            return LocationIdToString.getStringWithType(loc);
        }
        return LocationIdToString.getNonVerboseString(locations, loc, standalone);
    }

    private static String getNonVerboseString(LocationSet locations, Location loc, boolean standalone) {
        Collection<Location> locationsWithSameName = locations.getLocationsByDisplayName(loc.getDisplayName());
        if (locationsWithSameName.size() == 1) {
            return standalone ? loc.getDisplayName() : LocationIdToString.getNameForLocationInFullAncestorList(loc);
        }
        boolean canBeDisambiguatedByType = true;
        for (Location locationWithSameName : locationsWithSameName) {
            if (locationWithSameName == loc || locationWithSameName.getType() != loc.getType()) continue;
            canBeDisambiguatedByType = false;
        }
        if (canBeDisambiguatedByType || loc.getParent() == null) {
            return LocationIdToString.getStringWithType(loc);
        }
        return standalone ? loc.getDisplayName() + " (" + loc.getParent().getDisplayName() + ")" : LocationIdToString.getNameForLocationInFullAncestorList(loc) + " (" + LocationIdToString.getNameForLocationInFullAncestorList(loc.getParent()) + ")";
    }

    private static String getNameForLocationInFullAncestorList(Location loc) {
        String suffix;
        String displayName = loc.getDisplayName();
        String groupedLocationPrefix = Locations.getGroupedLocationPrefix(displayName);
        if (groupedLocationPrefix != null && loc.getParent() != null && loc.getParent().getDisplayName().equals(groupedLocationPrefix) && (suffix = Locations.getGroupedLocationGroupSuffix(displayName)) != null) {
            return suffix;
        }
        return displayName;
    }

    public static String getStringWithType(Location loc) {
        String name = loc.getDisplayName();
        if (loc.getType() != null && loc.getType() != Location.Type.region) {
            name = String.format("%s (%s)", name, Messages.getText(loc.getType()));
        }
        return name;
    }

    private void addToLocationIndex(Indexer<String> index, Location loc, Predicate<Location> locationPredicate) {
        if (locationPredicate.apply(loc)) {
            index.add(loc.getDisplayName(), loc.getId());
            boolean sameDisplayName = loc.getDisplayName().equals(loc.getModelName());
            if (!sameDisplayName) {
                index.add(loc.getModelName(), loc.getId());
            }
            if (loc.getParent() != null) {
                index.add(loc.getDisplayName() + " " + loc.getParent().getDisplayName(), loc.getId());
                if (!loc.getParent().getDisplayName().equals(loc.getParent().getModelName())) {
                    index.add(loc.getDisplayName() + " " + loc.getParent().getModelName(), loc.getId());
                    if (!sameDisplayName) {
                        index.add(loc.getModelName() + " " + loc.getParent().getModelName(), loc.getId());
                    }
                }
            }
        }
        for (Location child : loc.contents()) {
            this.addToLocationIndex(index, child, locationPredicate);
        }
    }

    private void registerSyntheticLocations(Indexer<String> indexer, SyntheticLocations syntheticLocations) {
        for (SyntheticLocation location : syntheticLocations.locations()) {
            indexer.add(location.getDisplayName(), location.getId());
        }
    }

    static {
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        builder.put("Mount", "Mt");
        builder.put("Mountain", "Mt");
        builder.put("Mt", "Mount");
        builder.put("Fort", "Ft");
        builder.put("Ft", "Fort");
        builder.put("St", "Saint");
        builder.put("Ste", "Sainte");
        builder.put("Saint", "St");
        ALTERNATE_INDEX_ENTRIES = builder.build();
    }
}

