/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.collect.ForwardingList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

public class ListListModel<T>
extends AbstractListModel<T> {
    private List<T> _list;

    public static <T> ListListModel<T> newInstance() {
        return new ListListModel<T>();
    }

    public static <T> ListListModel<T> newInstance(List<T> list) {
        return new ListListModel<T>(list);
    }

    public ListListModel() {
        this(Lists.newArrayList());
    }

    public ListListModel(List<T> list) {
        this._list = new Forward(list);
    }

    public List<T> asList() {
        return this._list;
    }

    @Override
    public int getSize() {
        return this._list.size();
    }

    @Override
    public T getElementAt(int pos) {
        return this._list.get(pos);
    }

    private class Forward
    extends ForwardingList<T> {
        private List<T> delegate;

        public Forward(List<T> list) {
            this.delegate = list;
        }

        @Override
        public void add(int index, T element) {
            super.add(index, element);
            ListListModel.this.fireIntervalAdded(this, index, index);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> elements) {
            boolean retVal = false;
            int currentIndex = index;
            for (Object element : elements) {
                super.add(currentIndex, element);
                ++currentIndex;
                retVal = true;
            }
            if (retVal) {
                ListListModel.this.fireIntervalAdded(this, index, index + elements.size() - 1);
            }
            return retVal;
        }

        @Override
        public T remove(int index) {
            Object retVal = super.remove(index);
            ListListModel.this.fireIntervalRemoved(this, index, index);
            return retVal;
        }

        @Override
        public T set(int index, T element) {
            Object retVal = super.set(index, element);
            ListListModel.this.fireContentsChanged(this, index, index);
            return retVal;
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.unmodifiableIterator(super.iterator());
        }

        @Override
        public boolean add(T element) {
            this.add(0, (T)element);
            return true;
        }

        @Override
        public boolean remove(Object element) {
            int index = this.indexOf(element);
            if (index < 0) {
                return false;
            }
            this.remove(index);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends T> collection) {
            return this.addAll(0, collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean retVal = false;
            for (Object o : collection) {
                retVal = this.remove(o) || retVal;
            }
            return retVal;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clear() {
            int size = this.size();
            super.clear();
            if (size > 0) {
                ListListModel.this.fireIntervalRemoved(this, 0, size - 1);
            }
        }

        @Override
        protected List<T> delegate() {
            return this.delegate;
        }
    }
}

