/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.util.ColorFunctions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Icons {
    private Icons() {
    }

    public static Icon getWhiteIconIfDark(Component component, Icon icon) {
        if (!FlatLaf.isLafDark()) {
            return icon;
        }
        return Icons.getWhiteIcon(component, icon);
    }

    public static Icon getWhiteIcon(Component component, Icon icon) {
        ImageIcon imageIcon = (ImageIcon)icon;
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
        Graphics2D g = image.createGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, null);
        g.dispose();
        icon.paintIcon(component, image.createGraphics(), 0, 0);
        for (int x = 0; x < icon.getIconWidth(); ++x) {
            for (int y = 0; y < icon.getIconHeight(); ++y) {
                int rgb = image.getRGB(x, y);
                if (rgb == 0) continue;
                Color color = new Color(rgb, true);
                Color lightened = ColorFunctions.lighten(color, 0.85f);
                image.setRGB(x, y, lightened.getRGB());
            }
        }
        return new ImageIcon(image);
    }

    public static Icon getDarkerIcon(Component component, Icon icon) {
        ImageIcon imageIcon = (ImageIcon)icon;
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
        Graphics2D g = image.createGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, null);
        g.dispose();
        icon.paintIcon(component, image.createGraphics(), 0, 0);
        for (int x = 0; x < icon.getIconWidth(); ++x) {
            for (int y = 0; y < icon.getIconHeight(); ++y) {
                int rgb = image.getRGB(x, y);
                if (rgb == 0) continue;
                Color color = new Color(rgb, true);
                Color darkened = ColorFunctions.darken(color, 0.4f);
                image.setRGB(x, y, darkened.getRGB());
            }
        }
        return new ImageIcon(image);
    }
}

