/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class GoogleGeocharts {
    public static final ImmutableMap<String, String> EBIRD_LOCATIONS_NOT_IN_GOOGLE = ImmutableBiMap.of("UM-71", "US-HI", "BQ-BO", "BQ");
    public static final ImmutableBiMap<String, String> EBIRD_TO_GOOGLE_COUNTRIES = ImmutableBiMap.of("FI-01", "AX");
    public static final ImmutableMap<String, String> EBIRD_STATE_TO_GOOGLE_STATE = ImmutableMap.builder().put("PH-ABR", "PH-15").put("PH-AGN", "PH-13").put("PH-AGS", "PH-13").put("PH-AKL", "PH-06").put("PH-ALB", "PH-05").put("PH-ANT", "PH-06").put("PH-APA", "PH-15").put("PH-AUR", "PH-03").put("PH-BAS", "PH-09").put("PH-BAN", "PH-03").put("PH-BTN", "PH-02").put("PH-BTG", "PH-40").put("PH-BEN", "PH-15").put("PH-BIL", "PH-08").put("PH-BOH", "PH-07").put("PH-BUK", "PH-10").put("PH-BUL", "PH-03").put("PH-CAG", "PH-02").put("PH-CAN", "PH-05").put("PH-CAS", "PH-05").put("PH-CAM", "PH-10").put("PH-CAP", "PH-06").put("PH-CAT", "PH-05").put("PH-CAV", "PH-40").put("PH-CEB", "PH-07").put("PH-COM", "PH-11").put("PH-NCO", "PH-12").put("PH-DAV", "PH-11").put("PH-DAS", "PH-11").put("PH-DVO", "PH-11").put("PH-DAO", "PH-11").put("PH-DIN", "PH-13").put("PH-EAS", "PH-08").put("PH-GUI", "PH-06").put("PH-IFU", "PH-15").put("PH-ILN", "PH-01").put("PH-ILS", "PH-01").put("PH-ILI", "PH-06").put("PH-ISA", "PH-02").put("PH-KAL", "PH-15").put("PH-LUN", "PH-01").put("PH-LAG", "PH-40").put("PH-LAN", "PH-12").put("PH-LAS", "PH-14").put("PH-LEY", "PH-08").put("PH-MAG", "PH-14").put("PH-MAD", "PH-41").put("PH-MAS", "PH-05").put("PH-MDC", "PH-41").put("PH-MDR", "PH-41").put("PH-MSC", "PH-10").put("PH-MSR", "PH-10").put("PH-MOU", "PH-15").put("PH-NEC", "PH-06").put("PH-NER", "PH-07").put("PH-NSA", "PH-08").put("PH-NUE", "PH-03").put("PH-NUV", "PH-02").put("PH-PLW", "PH-41").put("PH-PAM", "PH-03").put("PH-PAN", "PH-01").put("PH-QUE", "PH-40").put("PH-QUI", "PH-02").put("PH-RIZ", "PH-40").put("PH-ROM", "PH-41").put("PH-WSA", "PH-08").put("PH-SAR", "PH-11").put("PH-SIG", "PH-07").put("PH-SOR", "PH-05").put("PH-SCO", "PH-11").put("PH-SLE", "PH-08").put("PH-SUK", "PH-12").put("PH-SLU", "PH-14").put("PH-SUN", "PH-13").put("PH-SUR", "PH-13").put("PH-TAR", "PH-03").put("PH-TAW", "PH-14").put("PH-ZMB", "PH-03").put("PH-ZAN", "PH-09").put("PH-ZAS", "PH-09").put("PH-ZSI", "PH-09").build();
    private static final ImmutableMap<String, String> GOOGLE_LOCATION_NAMES = ImmutableMap.builder().put("PH-14", "Autonomous Region in Muslim Mindanao").put("PH-05", "Bicol").put("PH-02", "Cagayan Valley").put("PH-40", "Calabarzon").put("PH-13", "Caraga").put("PH-03", "Central Luzon").put("PH-07", "Central Visayas").put("PH-15", "Cordillera Administrative Region").put("PH-11", "Davao").put("PH-08", "Eastern Visayas").put("PH-01", "Ilocos").put("PH-41", "Mimaropa").put("PH-00", "National Capital Region").put("PH-10", "Northern Mindanao").put("PH-12", "Soccsksargen Rehiyon").put("PH-06", "Western Visayas").put("PH-09", "Zamboanga Peninsula").build();
    private final LocationSet locations;
    private final PredefinedLocations predefinedLocations;
    private static final ImmutableMap<String, String> STATE_TO_COUNTRY_CODE = ImmutableMap.of("CW", "BQ");
    private static final ImmutableSet<String> SMALL_COUNTRIES = ImmutableSet.of("PF", "CV", "CP", "CX", "CC", "AC", new String[]{"CK", "FJ", "TF", "HM", "KI", "LI", "MH", "MU", "YT", "FM", "NR", "NU", "NF", "PN", "RE", "SC", "WS", "TO", "TK", "TV", "GS", "SH", "WF", "VU", "AD", "SM", "HK", "SG", "AQ", "BH", "BM", "AS", "KM", "SC", "GU", "PW", "MP", "TL", "IC", "TC", "FO"});
    private static final List<Subcontinent> ALL_SUBCONTINENTS = new ArrayList<Subcontinent>();
    private static final List<Continent> ALL_CONTINENTS = new ArrayList<Continent>();
    private static final Subcontinent NORTHERN_AFRICA_015 = GoogleGeocharts.subcontinent("Northern Africa", "015", "DZ", "EG", "EH", "LY", "MA", "SD", "SS", "TN");
    private static final Subcontinent WESTERN_AFRICA_011 = GoogleGeocharts.subcontinent("Western Africa", "011", "BF", "BJ", "CI", "CV", "GH", "GM", "GN", "GW", "LR", "ML", "MR", "NE", "NG", "SL", "SN", "TG");
    private static final Subcontinent MIDDLE_AFRICA_017 = GoogleGeocharts.subcontinent("Middle Africa", "017", "AO", "CD", "ZR", "CF", "CG", "CM", "GA", "GQ", "ST", "TD");
    private static final Subcontinent EASTERN_AFRICA_014 = GoogleGeocharts.subcontinent("Eastern Africa", "014", "BI", "DJ", "ER", "ET", "KE", "KM", "MG", "MU", "MW", "MZ", "RE", "RW", "SC", "SO", "TZ", "UG", "YT", "ZM", "ZW");
    private static final Subcontinent SOUTHERN_AFRICA_018 = GoogleGeocharts.subcontinent("Southern Africa", "018", "BW", "LS", "NA", "SZ", "ZA");
    private static final Subcontinent NORTHERN_EUROPE_154 = GoogleGeocharts.subcontinent("Northern Europe", "154", "GG", "JE", "AX", "DK", "EE", "FI", "FO", "GB", "IE", "IM", "IS", "LT", "LV", "NO", "SE", "SJ");
    private static final Subcontinent WESTERN_EUROPE_155 = GoogleGeocharts.subcontinent("Western Europe", "155", "AT", "BE", "CH", "DE", "DD", "FR", "FX", "LI", "LU", "MC", "NL");
    private static final Subcontinent EASTERN_EUROPE_151 = GoogleGeocharts.subcontinent("Eastern Europe", "151", "BG", "BY", "CZ", "HU", "MD", "PL", "RO", "RU", "SU", "SK", "UA");
    private static final Subcontinent SOUTHERN_EUROPE_039 = GoogleGeocharts.subcontinent("Southern Europe", "039", "AD", "AL", "BA", "ES", "GI", "GR", "HR", "IT", "ME", "MK", "MT", "RS", "PT", "SI", "SM", "VA", "YU");
    private static final Subcontinent NORTHERN_AMERICA_021 = GoogleGeocharts.subcontinent("North America", "021", "BM", "CA", "GL", "PM", "US");
    private static final Subcontinent CARIBBEAN_029 = GoogleGeocharts.subcontinent("Caribbean", "029", "AG", "AI", "AW", "BB", "BL", "BQ", "BS", "CU", "DM", "DO", "GD", "GP", "HT", "JM", "KN", "KY", "LC", "MF", "MQ", "MS", "PR", "TC", "TT", "VC", "VG", "VI");
    private static final Subcontinent CENTRAL_AMERICA_013 = GoogleGeocharts.subcontinent("Central America", "013", "BZ", "CR", "GT", "HN", "MX", "NI", "PA", "SV");
    private static final Subcontinent SOUTH_AMERICA_005 = GoogleGeocharts.subcontinent("South America", "005", "AR", "BO", "BR", "CL", "CO", "EC", "FK", "GF", "GY", "PE", "PY", "SR", "UY", "VE");
    private static final Subcontinent CENTRAL_ASIA_143 = GoogleGeocharts.subcontinent("Central Asia", "143", "TM", "TJ", "KG", "KZ", "RU", "UZ");
    private static final Subcontinent EASTERN_ASIA_030 = GoogleGeocharts.subcontinent("Eastern Asia", "030", "CN", "HK", "JP", "KP", "KR", "MN", "MO", "TW");
    private static final Subcontinent SOUTHERN_ASIA_034 = GoogleGeocharts.subcontinent("Southern Asia", "034", "AF", "BD", "BT", "IN", "IR", "LK", "MV", "NP", "PK");
    private static final Subcontinent SOUTHEASTERN_ASIA_035 = GoogleGeocharts.subcontinent("Southeastern Asia", "035", "BN", "ID", "KH", "LA", "MM", "BU", "MY", "PH", "SG", "TH", "TL", "TP", "VN");
    private static final Subcontinent WESTERN_ASIA_145 = GoogleGeocharts.subcontinent("Western Asia", "145", "AE", "AM", "AZ", "BH", "CY", "GE", "IL", "IQ", "JO", "KW", "LB", "OM", "PS", "QA", "SA", "NT", "SY", "TR", "YE", "YD");
    private static final Subcontinent AUSTRALIA_NEW_ZEALAND_053 = GoogleGeocharts.subcontinent("Australia and New Zealand", "053", "AU", "NF", "NZ");
    private static final Subcontinent MELANESIA_054 = GoogleGeocharts.subcontinent("Melanesia", "054", "FJ", "NC", "PG", "SB", "VU");
    private static final Subcontinent MICRONESIA_057 = GoogleGeocharts.subcontinent("Micronesia", "057", "FM", "GU", "KI", "MH", "MP", "NR", "PW");
    private static final Subcontinent POLYNESIA_061 = GoogleGeocharts.subcontinent("Polynesia", "061", "AS", "CK", "NU", "PF", "PN", "TK", "TO", "TV", "WF", "WS");

    public GoogleGeocharts(LocationSet locations, PredefinedLocations predefinedLocations) {
        this.locations = locations;
        this.predefinedLocations = predefinedLocations;
    }

    public String getNameForGoogle(String ebirdCode) {
        Collection<Object> possibleLocations;
        Location location;
        if (GOOGLE_LOCATION_NAMES.containsKey(ebirdCode)) {
            return GOOGLE_LOCATION_NAMES.get(ebirdCode);
        }
        if (EBIRD_TO_GOOGLE_COUNTRIES.containsValue(ebirdCode)) {
            ebirdCode = (String)((ImmutableMap)((Object)EBIRD_TO_GOOGLE_COUNTRIES.inverse())).get(ebirdCode);
        }
        if ((location = this.locations.getLocationByCode(ebirdCode)) != null) {
            return location.getDisplayName();
        }
        int hyphen = ebirdCode.indexOf(45);
        if (hyphen > 0) {
            String justCountry = ebirdCode.substring(0, hyphen);
            possibleLocations = this.locations.getLocationsByCode(justCountry);
        } else if (STATE_TO_COUNTRY_CODE.containsKey(ebirdCode)) {
            String actualCountry = STATE_TO_COUNTRY_CODE.get(ebirdCode);
            possibleLocations = this.locations.getLocationsByCode(actualCountry);
        } else {
            possibleLocations = ImmutableList.of();
        }
        for (Location possibleLocation : possibleLocations) {
            PredefinedLocations.PredefinedLocation predefinedChild = this.predefinedLocations.getPredefinedLocationChildByCode(possibleLocation, ebirdCode);
            if (predefinedChild == null) continue;
            return predefinedChild.getName();
        }
        return ebirdCode;
    }

    public ImmutableSet<Subcontinent> subcontinents(Set<String> countries) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Subcontinent subcontinent : ALL_SUBCONTINENTS) {
            if (!subcontinent.containsAnyOf(countries)) continue;
            builder.add(subcontinent);
        }
        return builder.build();
    }

    public ImmutableSet<Continent> continents(Set<Subcontinent> subcontinents) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Continent continent : ALL_CONTINENTS) {
            if (!continent.containsAnyOf(subcontinents)) continue;
            builder.add(continent);
        }
        return builder.build();
    }

    private static Subcontinent subcontinent(String name, String id, String ... countries) {
        Subcontinent subcontinent = new Subcontinent(name, id, ImmutableSet.copyOf(countries));
        ALL_SUBCONTINENTS.add(subcontinent);
        return subcontinent;
    }

    private static Continent continent(String name, String id, Subcontinent ... subcontinents) {
        Continent continent = new Continent(name, id, ImmutableSet.copyOf(subcontinents));
        ALL_CONTINENTS.add(continent);
        return continent;
    }

    static {
        GoogleGeocharts.continent("Africa", "002", NORTHERN_AFRICA_015, WESTERN_AFRICA_011, MIDDLE_AFRICA_017, EASTERN_AFRICA_014, SOUTHERN_AFRICA_018);
        GoogleGeocharts.continent("Europe", "150", NORTHERN_EUROPE_154, WESTERN_EUROPE_155, EASTERN_EUROPE_151, SOUTHERN_EUROPE_039);
        GoogleGeocharts.continent("Americas", "019", NORTHERN_AMERICA_021, CARIBBEAN_029, CENTRAL_AMERICA_013, SOUTH_AMERICA_005);
        GoogleGeocharts.continent("Asia", "142", CENTRAL_ASIA_143, EASTERN_ASIA_030, SOUTHERN_ASIA_034, SOUTHEASTERN_ASIA_035, WESTERN_ASIA_145);
        GoogleGeocharts.continent("Oceania", "009", AUSTRALIA_NEW_ZEALAND_053, MELANESIA_054, MICRONESIA_057, POLYNESIA_061);
    }

    public static class Subcontinent
    extends Region {
        final ImmutableSet<String> countries;

        Subcontinent(String name, String id, ImmutableSet<String> countries) {
            super("&nbsp;&nbsp;" + name, id);
            this.countries = countries;
        }

        public boolean containsAnyOf(Set<String> countries) {
            return !Sets.intersection(countries, this.countries).isEmpty();
        }

        public boolean contains(String country) {
            return this.countries.contains(country);
        }
    }

    public static class Continent
    extends Region {
        final ImmutableSet<Subcontinent> subcontinents;

        Continent(String name, String id, ImmutableSet<Subcontinent> subcontinents) {
            super(name, id);
            this.subcontinents = subcontinents;
        }

        boolean containsAnyOf(Set<Subcontinent> subcontinents) {
            return !Sets.intersection(subcontinents, this.subcontinents).isEmpty();
        }

        public ImmutableSet<Subcontinent> subcontinents() {
            return this.subcontinents;
        }
    }

    public static class Region {
        final String name;
        final String id;

        Region(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public String id() {
            return this.id;
        }

        public String asOption() {
            return String.format("<option value=\"?%s\">%s</option>", this.id, this.name);
        }
    }
}

