/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;

public abstract class FocusTracker {
    private final JComponent component;
    private final PropertyChangeListener focusChangeListener = new FocusListener();
    private Component lastFocused = null;

    protected FocusTracker(JComponent component) {
        this.component = component;
        component.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                FocusTracker.this.installFocus();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                FocusTracker.this.uninstallFocus();
            }
        });
        if (component.isShowing()) {
            this.installFocus();
        }
    }

    protected abstract void focusGained(Component var1);

    protected abstract void focusLost(Component var1);

    private void installFocus() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addPropertyChangeListener("focusOwner", this.focusChangeListener);
        this.focusChangeListener.propertyChange(new PropertyChangeEvent(manager, "focusOwner", null, manager.getFocusOwner()));
    }

    private boolean isTargetOfTrackerInternal(Component potentialTarget) {
        if (!this.includeTextComponents() && potentialTarget instanceof JTextComponent) {
            return false;
        }
        return this.isTargetOfTracker(potentialTarget);
    }

    protected boolean isTargetOfTracker(Component potentialTarget) {
        return potentialTarget != null && (this.component == potentialTarget || this.component.isAncestorOf(potentialTarget));
    }

    protected boolean includeTextComponents() {
        return false;
    }

    private void uninstallFocus() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.removePropertyChangeListener("focusOwner", this.focusChangeListener);
        this.focusChangeListener.propertyChange(new PropertyChangeEvent(manager, "focusOwner", manager.getFocusOwner(), null));
    }

    private class FocusListener
    implements PropertyChangeListener {
        private FocusListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Component oldOwner = FocusTracker.this.lastFocused != null ? FocusTracker.this.lastFocused : (Component)event.getOldValue();
            Component newOwner = (Component)event.getNewValue();
            if (this.shouldIgnoreLostFocus(newOwner)) {
                return;
            }
            boolean hadFocus = FocusTracker.this.isTargetOfTrackerInternal(oldOwner);
            boolean hasFocus = FocusTracker.this.isTargetOfTrackerInternal(newOwner);
            if (hasFocus) {
                FocusTracker.this.focusGained(newOwner);
                FocusTracker.this.lastFocused = newOwner;
            } else if (hadFocus) {
                FocusTracker.this.focusLost(oldOwner);
                FocusTracker.this.lastFocused = null;
            }
        }

        private boolean shouldIgnoreLostFocus(Component newOwner) {
            if (newOwner == null || newOwner instanceof JRootPane) {
                return true;
            }
            while (newOwner != null) {
                if (newOwner instanceof JMenuBar || newOwner instanceof JMenu) {
                    return true;
                }
                newOwner = newOwner.getParent();
            }
            return false;
        }
    }
}

