/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class FixDropTargetScrolling {
    private static final Logger logger = Logger.getLogger(FixDropTargetScrolling.class.getName());

    public static void install(Component c, Insets insets) {
        if (UIUtils.isMacOS()) {
            try {
                c.getDropTarget().addDropTargetListener(new Listener(c, insets));
            }
            catch (TooManyListenersException e) {
                logger.log(Level.WARNING, "Could not install drop-target scrolling", e);
            }
        }
    }

    static class Listener
    implements DropTargetListener,
    ActionListener {
        private final Component component;
        private final Insets insets;
        private Timer timer = new Timer(100, this);
        private Point cursorLocation;
        private int count;

        Listener(Component component, Insets insets) {
            this.component = component;
            this.insets = insets;
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            this.cursorLocation = e.getLocation();
            this.timer.start();
            this.count = 0;
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            this.timer.stop();
            this.cursorLocation = null;
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            this.cursorLocation = e.getLocation();
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            this.timer.stop();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.cursorLocation == null) {
                this.count = 0;
                return;
            }
            JViewport viewport = this.getViewport();
            Point viewPosition = viewport.getViewPosition();
            Dimension extentSize = viewport.getExtentSize();
            int viewportCursorX = this.cursorLocation.x - viewPosition.x;
            int viewportCursorY = this.cursorLocation.y - viewPosition.y;
            int scrollX = 0;
            int scrollY = 0;
            int multiplier = this.count >= 20 ? 4 : (this.count >= 10 ? 2 : 1);
            Dimension size = this.component.getSize();
            if (viewportCursorX < this.insets.left) {
                scrollX = multiplier * -this.insets.left;
            } else if (viewportCursorX > extentSize.width - this.insets.right) {
                scrollX = multiplier * this.insets.right;
            }
            if (viewportCursorY < this.insets.top) {
                scrollY = multiplier * -this.insets.top;
            } else if (viewportCursorY > extentSize.height - this.insets.bottom) {
                scrollY = multiplier * this.insets.bottom;
            }
            if (scrollX == 0 && scrollY == 0) {
                this.count = 0;
                return;
            }
            Point newViewPosition = new Point(viewPosition);
            newViewPosition.x += scrollX;
            newViewPosition.x = Math.max(0, newViewPosition.x);
            newViewPosition.x = Math.min(newViewPosition.x, size.width - extentSize.width);
            newViewPosition.y += scrollY;
            newViewPosition.y = Math.max(0, newViewPosition.y);
            newViewPosition.y = Math.min(newViewPosition.y, size.height - extentSize.height);
            if (!newViewPosition.equals(viewPosition)) {
                viewport.setViewPosition(newViewPosition);
                this.cursorLocation.x += newViewPosition.x - viewPosition.x;
                this.cursorLocation.y += newViewPosition.y - viewPosition.y;
                ++this.count;
            } else {
                this.count = 0;
            }
        }

        private JViewport getViewport() {
            return (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.component);
        }
    }
}

