/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.TaxonVisitor;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.BKTree;
import com.scythebill.birdlist.model.util.Metrics;
import com.scythebill.birdlist.model.util.ResolvedComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class FindSpeciesInText {
    private static final int MAX_BUFFER_SIZE = 5;
    private static final CharMatcher NOT_IN_WORD = CharMatcher.whitespace().or(CharMatcher.inRange('0', '9')).or(CharMatcher.anyOf("-\u2010_,/{}*\\|!@#$%^&\";:.<>?=+`~"));
    private static final CharMatcher IN_WORD = NOT_IN_WORD.negate();
    private final TaxonImporter taxonImporter;
    private static final CharMatcher WHITESPACE_BUT_NOT_NEWLINES = CharMatcher.whitespace().and(CharMatcher.isNot('\n')).precomputed();
    private static final CharMatcher CHARS_TO_REMOVE_IN_NORMALIZATION = CharMatcher.anyOf("_- \"'\u2019\u2010()[]");

    public FindSpeciesInText(Taxonomy taxonomy, @Nullable Checklist checklist) {
        this.taxonImporter = new TaxonImporter(taxonomy, checklist);
    }

    public TaxonSearch primarySearch() {
        return this.taxonImporter.primarySearch();
    }

    public TaxonSearch secondarySearch(boolean onlySingletonMatches) {
        return this.taxonImporter.secondarySearch(onlySingletonMatches);
    }

    public TaxonSearch tertiarySearch() {
        return this.taxonImporter.tertiarySearch();
    }

    public Results search(String text, TaxonSearch search) {
        TreeSet<SightingTaxon.Resolved> taxa = Sets.newTreeSet(new ResolvedComparator());
        String remaining = this.searchPass(text, taxa, search);
        String remainingMinusEmptyLines = FindSpeciesInText.removeEmptyLines(remaining);
        return new Results(taxa, remainingMinusEmptyLines);
    }

    private String searchPass(String text, Set<SightingTaxon.Resolved> taxa, TaxonSearch searcher) {
        int nextWordEnd;
        ArrayList<Word> buffer = Lists.newArrayListWithCapacity(5);
        StringBuilder unusedText = new StringBuilder();
        int startOfTextToBeFlushed = 0;
        int wordStart = IN_WORD.indexIn(text);
        while (wordStart < text.length() && wordStart >= 0 && ((nextWordEnd = NOT_IN_WORD.indexIn(text, wordStart)) >= 0 || wordStart < (nextWordEnd = text.length()))) {
            if (nextWordEnd - wordStart == 1) {
                while (!buffer.isEmpty()) {
                    startOfTextToBeFlushed = this.flushBuffer(text, taxa, searcher, buffer, unusedText, startOfTextToBeFlushed);
                }
                wordStart = IN_WORD.indexIn(text, nextWordEnd);
                continue;
            }
            Word next = new Word(text, wordStart, nextWordEnd);
            buffer.add(next);
            wordStart = IN_WORD.indexIn(text, nextWordEnd);
            if (buffer.size() != 5) continue;
            startOfTextToBeFlushed = this.flushBuffer(text, taxa, searcher, buffer, unusedText, startOfTextToBeFlushed);
        }
        while (!buffer.isEmpty()) {
            startOfTextToBeFlushed = this.flushBuffer(text, taxa, searcher, buffer, unusedText, startOfTextToBeFlushed);
        }
        FindSpeciesInText.appendTrimmingWhitespace(unusedText, text.substring(startOfTextToBeFlushed));
        return unusedText.toString();
    }

    private int flushBuffer(String text, Set<SightingTaxon.Resolved> taxa, TaxonSearch searcher, List<Word> buffer, StringBuilder unusedText, int startOfTextToBeFlushed) {
        int startingBufferSize = buffer.size();
        Word start = buffer.get(0);
        for (int i = buffer.size() - 1; i >= 0; --i) {
            Word end = buffer.get(i);
            String possibility = FindSpeciesInText.toLowerCaseAndMore(text.substring(start.start, end.end));
            Collection<Taxon> found = searcher.search(possibility);
            if ((found == null || found.isEmpty()) && possibility.length() > 2 && ((found = searcher.search(possibility = possibility.substring(0, possibility.length() - 1))) == null || found.isEmpty()) && possibility.length() > 2) {
                possibility = possibility.substring(0, possibility.length() - 1);
                found = searcher.search(possibility);
            }
            if (found == null || found.isEmpty()) continue;
            for (Taxon taxon : found) {
                taxa.add(SightingTaxons.newResolved(taxon));
            }
            for (int j = 0; j <= i; ++j) {
                buffer.remove(0);
            }
            FindSpeciesInText.appendTrimmingWhitespace(unusedText, text.substring(startOfTextToBeFlushed, start.start));
            startOfTextToBeFlushed = end.end;
            break;
        }
        if (buffer.size() == startingBufferSize) {
            buffer.remove(0);
        }
        return startOfTextToBeFlushed;
    }

    private static void appendTrimmingWhitespace(StringBuilder builder, CharSequence text) {
        if (builder.length() != 0 && WHITESPACE_BUT_NOT_NEWLINES.matches(builder.charAt(builder.length() - 1))) {
            builder.append(WHITESPACE_BUT_NOT_NEWLINES.trimLeadingFrom(text));
        } else {
            builder.append(text);
        }
    }

    private static String toLowerCaseAndMore(String s) {
        s = CHARS_TO_REMOVE_IN_NORMALIZATION.removeFrom(s);
        s = s.toLowerCase();
        s = s.replace("gray", "grey");
        s = s.replace("colour", "color");
        s = s.replace("racquet", "racket");
        s = s.replace("geese", "goose");
        s = s.replace("\u00f6", "oe");
        s = s.replace("\u00fc", "ue");
        s = s.replace('\u00b4', '\'');
        return s;
    }

    private static String removeEmptyLines(String string) {
        StringBuilder buffer = new StringBuilder(string.length());
        for (String line : Splitter.on('\n').split(string)) {
            if (CharMatcher.whitespace().matchesAllOf(line)) continue;
            buffer.append(line);
            buffer.append('\n');
        }
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == '\n') {
            return buffer.substring(0, buffer.length() - 1);
        }
        return buffer.toString();
    }

    private static String trimSuffixes(String alternate) {
        int indexOf = alternate.indexOf(" -");
        if (indexOf > 0) {
            return alternate.substring(0, indexOf);
        }
        return alternate;
    }

    static class TaxonImporter {
        private final Map<String, Taxon> newGenusNames = Maps.newTreeMap(String.CASE_INSENSITIVE_ORDER);
        private final Multimap<String, Taxon> newSpeciesNames = HashMultimap.create();
        private final Multimap<String, Taxon> newCommonNames = HashMultimap.create();
        private final Multimap<String, Taxon> alternateCommonNames = HashMultimap.create();
        private final Multimap<String, Taxon> alternateSciNames = HashMultimap.create();
        private final BKTree<String, Taxon> commonNameTree;
        private final BKTree<String, Taxon> alternateCommonNameTree;
        private final Taxonomy taxonomy;

        public TaxonImporter(Taxonomy taxonomy, Checklist checklist) {
            this.taxonomy = taxonomy;
            BKTree.Builder<String, Taxon> commonNameTree = BKTree.builder(Metrics.levenshteinDistance());
            if (checklist == null) {
                this.buildIndicesForTaxonomy(commonNameTree);
            } else {
                this.buildIndicesForTaxonomyFromChecklist(commonNameTree, checklist);
            }
            this.commonNameTree = commonNameTree.build();
            BKTree.Builder<String, Taxon> alternateCommonNameTree = BKTree.builder(Metrics.levenshteinDistance());
            for (Map.Entry<String, Collection<Taxon>> alternateEntry : this.alternateCommonNames.asMap().entrySet()) {
                if (alternateEntry.getValue().size() != 1) continue;
                alternateCommonNameTree.add(FindSpeciesInText.trimSuffixes(alternateEntry.getKey()), (Taxon)Iterables.getOnlyElement((Iterable)alternateEntry.getValue()));
            }
            this.alternateCommonNameTree = alternateCommonNameTree.build();
        }

        public TaxonSearch primarySearch() {
            return new TaxonSearch(){

                @Override
                public Collection<Taxon> search(String possibility) {
                    Collection<Taxon> collection = newCommonNames.get(possibility);
                    if (collection.size() == 1) {
                        return collection;
                    }
                    collection = newSpeciesNames.get(possibility);
                    if (collection.size() == 1) {
                        return collection;
                    }
                    return null;
                }
            };
        }

        public TaxonSearch tertiarySearch() {
            return new TaxonSearch(){

                @Override
                public Collection<Taxon> search(String possibility) {
                    if (possibility.length() > 6) {
                        List<Taxon> collection = commonNameTree.search(possibility, 1);
                        return collection;
                    }
                    Iterator<String> split = Splitter.on(' ').split(possibility).iterator();
                    String genusName = split.next();
                    if (split.hasNext()) {
                        Taxon matchWithinGenus;
                        Taxon genus;
                        String species = split.next();
                        if (!split.hasNext() && (genus = newGenusNames.get(genusName)) != null && (matchWithinGenus = TaxonImporter.findMatchWithin(genus, species, true)) != null) {
                            return ImmutableList.of(matchWithinGenus);
                        }
                    }
                    return null;
                }
            };
        }

        public TaxonSearch secondarySearch(final boolean onlySingletonMatches) {
            return new TaxonSearch(){

                @Override
                public Collection<Taxon> search(String possibility) {
                    Collection<Taxon> collection = alternateCommonNames.get(possibility);
                    if (!onlySingletonMatches || collection.size() == 1) {
                        return collection;
                    }
                    return null;
                }
            };
        }

        public Taxon search(String possibility) {
            int distanceAllowed;
            int distanceAllowed2;
            Collection<Taxon> collection = this.newCommonNames.get(possibility);
            if (collection.size() == 1) {
                return Iterables.getOnlyElement(collection);
            }
            collection = this.newSpeciesNames.get(possibility);
            if (collection.size() == 1) {
                return Iterables.getOnlyElement(collection);
            }
            if (possibility.length() > 3 && (collection = this.commonNameTree.search(possibility, distanceAllowed2 = possibility.length() < 5 ? 1 : 2)).size() == 1) {
                return Iterables.getOnlyElement(collection);
            }
            Iterator<String> split = Splitter.on(' ').split(possibility).iterator();
            String genusName = split.next();
            if (split.hasNext()) {
                Taxon matchWithinGenus;
                Taxon genus;
                String species = split.next();
                if (!split.hasNext() && (genus = this.newGenusNames.get(genusName)) != null && (matchWithinGenus = TaxonImporter.findMatchWithin(genus, species, true)) != null) {
                    return matchWithinGenus;
                }
            }
            if ((collection = this.alternateCommonNames.get(possibility)).size() == 1) {
                return Iterables.getOnlyElement(collection);
            }
            if (possibility.length() > 3 && (collection = this.alternateCommonNameTree.search(possibility, distanceAllowed = possibility.length() < 5 ? 1 : 2)).size() == 1) {
                return Iterables.getOnlyElement(collection);
            }
            return null;
        }

        private void buildIndicesForTaxonomy(BKTree.Builder<String, Taxon> commonNameTreeBuilder) {
            TaxonUtils.visitTaxa(this.taxonomy, (TaxonVisitor)new IndexBuilder(commonNameTreeBuilder));
        }

        private void buildIndicesForTaxonomyFromChecklist(BKTree.Builder<String, Taxon> commonNameTreeBuilder, Checklist checklist) {
            IndexBuilder indexBuilder = new IndexBuilder(commonNameTreeBuilder);
            HashSet<String> visited = Sets.newHashSet();
            for (SightingTaxon sightingTaxon : checklist.getTaxa(this.taxonomy)) {
                for (String id : sightingTaxon.getIds()) {
                    Taxon genus;
                    Taxon taxon = this.taxonomy.getTaxon(id);
                    if (taxon.getType() == Taxon.Type.species) {
                        if (!visited.contains(id)) {
                            visited.add(id);
                            indexBuilder.visitTaxon(taxon);
                        }
                    } else {
                        Taxon species = TaxonUtils.getParentOfType(taxon, Taxon.Type.species);
                        if (!visited.contains(species.getId())) {
                            visited.add(species.getId());
                            indexBuilder.visitTaxon(species);
                        }
                    }
                    if (visited.contains((genus = TaxonUtils.getParentOfType(taxon, Taxon.Type.genus)).getId())) continue;
                    visited.add(genus.getId());
                    indexBuilder.visitTaxon(genus);
                }
            }
        }

        static Taxon findMatchWithin(Taxon parent, String name, boolean preferGroups) {
            ArrayList matches = Lists.newArrayList();
            TaxonUtils.visitTaxa(parent, taxon -> {
                if (taxon != parent && name.equals(taxon.getName())) {
                    matches.add(taxon);
                    return false;
                }
                return true;
            });
            if (matches.isEmpty()) {
                TaxonUtils.visitTaxa(parent, taxon -> {
                    if (taxon != parent && TaxonImporter.equalsOrClose(name, taxon.getName())) {
                        matches.add(taxon);
                        return false;
                    }
                    return true;
                });
            }
            if (matches.size() != 1) {
                return null;
            }
            Taxon match = (Taxon)matches.get(0);
            if (preferGroups && match.getType() == Taxon.Type.subspecies && match.getParent().getType() == Taxon.Type.group) {
                match = match.getParent();
            }
            return match;
        }

        private static boolean equalsOrClose(String a, String b) {
            return a.equals(b) || LevenshteinDistance.getDefaultInstance().apply(a, b) <= 2;
        }

        private class IndexBuilder
        implements TaxonVisitor {
            private BKTree.Builder<String, Taxon> commonNameTreeBuilder;

            IndexBuilder(BKTree.Builder<String, Taxon> commonNameTreeBuilder) {
                this.commonNameTreeBuilder = commonNameTreeBuilder;
            }

            @Override
            public boolean visitTaxon(Taxon taxon) {
                switch (taxon.getType()) {
                    case genus: {
                        TaxonImporter.this.newGenusNames.put(FindSpeciesInText.toLowerCaseAndMore(taxon.getName()), taxon);
                        break;
                    }
                    case species: {
                        TaxonImporter.this.newSpeciesNames.put(FindSpeciesInText.toLowerCaseAndMore(TaxonUtils.getFullName(taxon)), taxon);
                    }
                    case group: 
                    case subspecies: {
                        if (taxon.getCommonName() != null) {
                            String commonName = FindSpeciesInText.toLowerCaseAndMore(taxon.getCommonName());
                            TaxonImporter.this.newCommonNames.put(commonName, taxon);
                            this.commonNameTreeBuilder.add(commonName, taxon);
                        }
                        for (String alternateCommonName : ((Species)taxon).getAlternateCommonNames()) {
                            if (alternateCommonName.indexOf(32) < 0) continue;
                            alternateCommonName = FindSpeciesInText.toLowerCaseAndMore(FindSpeciesInText.trimSuffixes(alternateCommonName));
                            TaxonImporter.this.alternateCommonNames.put(alternateCommonName, taxon);
                        }
                        for (String alternateSciName : ((Species)taxon).getAlternateNames()) {
                            TaxonImporter.this.alternateSciNames.put(FindSpeciesInText.toLowerCaseAndMore(alternateSciName), taxon);
                        }
                        break;
                    }
                }
                return true;
            }
        }
    }

    public static interface TaxonSearch {
        public Collection<Taxon> search(String var1);
    }

    public static class Results {
        public final ImmutableSet<SightingTaxon.Resolved> found;
        public final String remainingText;

        Results(Set<SightingTaxon.Resolved> found, String remainingText) {
            this.found = ImmutableSet.copyOf(found);
            this.remainingText = remainingText;
        }
    }

    private static class Word {
        final int start;
        final int end;

        Word(String text, int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

