/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.util.ReportSetScanner;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;

public class EncounteredTaxa {
    private ImmutableSet<String> taxonIds;

    private EncounteredTaxa(ImmutableSet<String> taxonIds) {
        this.taxonIds = taxonIds;
    }

    public boolean isEncountered(Taxon taxon) {
        return this.taxonIds.contains(taxon.getId());
    }

    public boolean isEncountered(String taxonId) {
        return this.taxonIds.contains(taxonId);
    }

    public static ListenableFuture<EncounteredTaxa> scan(Taxonomy taxonomy, ReportSet reportSet, ListeningExecutorService executorService) {
        TaxaScanner scanner = new TaxaScanner(taxonomy, reportSet);
        return executorService.submit((Callable)scanner);
    }

    static class TaxaScanner
    extends ReportSetScanner<EncounteredTaxa> {
        private final Set<String> taxonIds = new LinkedHashSet<String>();

        TaxaScanner(Taxonomy taxonomy, ReportSet reportSet) {
            super(taxonomy, reportSet);
        }

        @Override
        protected void process(Sighting sighting, SightingTaxon taxon) throws Exception {
            if (taxon.getType() == SightingTaxon.Type.SINGLE) {
                this.addTaxa(taxon.getId());
            } else {
                for (String taxonId : taxon.getIds()) {
                    this.addTaxa(taxonId);
                }
            }
        }

        private void addTaxa(String taxonId) {
            Taxon taxon = null;
            while (taxonId != null && this.taxonIds.add(taxonId)) {
                taxon = taxon == null ? this.getTaxonomy().getTaxon(taxonId).getParent() : taxon.getParent();
                taxonId = taxon == null ? null : taxon.getId();
            }
        }

        @Override
        protected EncounteredTaxa accumulated() {
            return new EncounteredTaxa(ImmutableSet.copyOf(this.taxonIds));
        }
    }
}

