/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.util.ReportSetScanner;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;

public class EncounteredLocations {
    private ImmutableSet<String> locationIds;

    private EncounteredLocations(ImmutableSet<String> locationIds) {
        this.locationIds = locationIds;
    }

    public boolean encounteredLocation(Location location) {
        return this.locationIds.contains(location.getId());
    }

    public static ListenableFuture<EncounteredLocations> scan(Taxonomy taxonomy, ReportSet reportSet, ListeningExecutorService executorService) {
        LocationScanner scanner = new LocationScanner(taxonomy, reportSet);
        return executorService.submit((Callable)scanner);
    }

    static class LocationScanner
    extends ReportSetScanner<EncounteredLocations> {
        private final Set<String> locationIds = new LinkedHashSet<String>();
        private final LocationSet locations;

        LocationScanner(Taxonomy taxonomy, ReportSet reportSet) {
            super(taxonomy, reportSet);
            this.locations = reportSet.getLocations();
        }

        @Override
        protected void process(Sighting sighting, SightingTaxon taxon) throws Exception {
            String locationId = sighting.getLocationId();
            Location location = null;
            while (locationId != null && this.locationIds.add(locationId)) {
                location = location == null ? this.locations.getLocation(locationId).getParent() : location.getParent();
                locationId = location == null ? null : location.getId();
            }
        }

        @Override
        protected EncounteredLocations accumulated() {
            return new EncounteredLocations(ImmutableSet.copyOf(this.locationIds));
        }

        @Override
        protected boolean resolveTaxaToTaxonomy() {
            return false;
        }
    }
}

