/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class DesktopUtils {
    private DesktopUtils() {
    }

    public static void openHtmlFileInBrowser(File file) throws IOException {
        if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(file.toURI());
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Desktop.getDesktop().open(file);
    }

    public static void openUrlInBrowser(URI uri, Alerts alerts) {
        block6: {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(uri);
                    return;
                }
                catch (IOException e) {
                    if (UIUtils.isLinux()) break block6;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(uri.toASCIIString()), null);
                    alerts.showMessage(null, Messages.Name.COULDNT_OPEN_WEB_PAGE_TITLE, Messages.Name.COULDNT_OPEN_WEB_PAGE_MESSAGE, uri.toASCIIString());
                    return;
                }
            }
        }
        if (UIUtils.isLinux()) {
            try {
                Runtime.getRuntime().exec(String.format("xdg-open '%s'", uri.toASCIIString()));
            }
            catch (IOException e) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(uri.toASCIIString()), null);
                alerts.showMessage(null, Messages.Name.COULDNT_OPEN_WEB_PAGE_TITLE, Messages.Name.COULDNT_OPEN_WEB_PAGE_MESSAGE, uri.toASCIIString());
                return;
            }
        }
    }

    public static boolean isBrowseSupported() {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE) || UIUtils.isLinux();
    }
}

